/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop;

import at.petrak.hexcasting.interop.pehkui.PehkuiInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.hexcasting.xplat.Platform;
import java.util.List;
import vazkii.patchouli.api.PatchouliAPI;

public class HexInterop {
    public static final String PATCHOULI_ANY_INTEROP_FLAG = "hexcasting:any_interop";
    public static final String PEHKUI_ID = "pehkui";

    public static void init() {
        HexInterop.initPatchouli();
        IXplatAbstractions xplat = IXplatAbstractions.INSTANCE;
        if (xplat.isModPresent(PEHKUI_ID)) {
            PehkuiInterop.init();
        }
        xplat.initPlatformSpecific();
    }

    private static void initPatchouli() {
        List<String> integrations = List.of(PEHKUI_ID);
        boolean anyInterop = false;
        for (String id : integrations) {
            if (!IXplatAbstractions.INSTANCE.isModPresent(id)) continue;
            anyInterop = true;
            break;
        }
        if (!anyInterop) {
            List<Object> platformSpecificIntegrations;
            Platform platform = IXplatAbstractions.INSTANCE.platform();
            if (platform == Platform.FORGE) {
                platformSpecificIntegrations = List.of();
            } else if (platform == Platform.FABRIC) {
                platformSpecificIntegrations = List.of("gravitychanger");
            } else {
                throw new UnsupportedOperationException();
            }
            for (String id : platformSpecificIntegrations) {
                if (!IXplatAbstractions.INSTANCE.isModPresent(id)) continue;
                anyInterop = true;
                break;
            }
        }
        PatchouliAPI.get().setConfigFlag(PATCHOULI_ANY_INTEROP_FLAG, anyInterop);
    }

    public static final class Fabric {
        public static final String GRAVITY_CHANGER_API_ID = "gravitychanger";
    }

    public static final class Forge {
    }
}

