/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.cap;

import at.petrak.hexcasting.api.addldata.Colorizer;
import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.addldata.HexHolder;
import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.item.ColorizerItem;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.forge.cap.ForgeImpetusCapability;
import at.petrak.hexcasting.forge.cap.HexCapabilities;
import java.util.List;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeCapabilityHandler {
    private static final ResourceLocation DATA_HOLDER_CAPABILITY = new ResourceLocation("hexcasting", "data_holder");
    private static final ResourceLocation DATA_ITEM_CAPABILITY = new ResourceLocation("hexcasting", "data_item");
    private static final ResourceLocation MANA_HOLDER_CAPABILITY = new ResourceLocation("hexcasting", "mana_holder");
    private static final ResourceLocation MANA_ITEM_CAPABILITY = new ResourceLocation("hexcasting", "mana_item");
    private static final ResourceLocation SPELL_HOLDER_CAPABILITY = new ResourceLocation("hexcasting", "spell_item");
    private static final ResourceLocation COLORIZER_CAPABILITY = new ResourceLocation("hexcasting", "colorizer");
    private static final ResourceLocation IMPETUS_HANDLER = new ResourceLocation("hexcasting", "impetus_items");

    public static void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(ManaHolder.class);
        evt.register(DataHolder.class);
        evt.register(HexHolder.class);
        evt.register(Colorizer.class);
    }

    public static void attachItemCaps(AttachCapabilitiesEvent<ItemStack> evt) {
        Object holder;
        ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.m_41720_();
        if (item instanceof ManaHolderItem) {
            holder = (ManaHolderItem)item;
            evt.addCapability(MANA_HOLDER_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.MANA, () -> ForgeCapabilityHandler.lambda$attachItemCaps$0((ManaHolderItem)holder, stack)));
        } else if (stack.m_150930_(HexItems.AMETHYST_DUST)) {
            evt.addCapability(MANA_ITEM_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.MANA, () -> new StaticManaHolder(HexConfig.common()::dustManaAmount, 3, stack)));
        } else if (stack.m_150930_(Items.f_151049_)) {
            evt.addCapability(MANA_ITEM_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.MANA, () -> new StaticManaHolder(HexConfig.common()::shardManaAmount, 2, stack)));
        } else if (stack.m_150930_(HexItems.CHARGED_AMETHYST)) {
            evt.addCapability(MANA_ITEM_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.MANA, () -> new StaticManaHolder(HexConfig.common()::chargedCrystalManaAmount, 1, stack)));
        }
        item = stack.m_41720_();
        if (item instanceof DataHolderItem) {
            holder = (DataHolderItem)item;
            evt.addCapability(DATA_HOLDER_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.DATUM, () -> ForgeCapabilityHandler.lambda$attachItemCaps$4((DataHolderItem)holder, stack)));
        } else if (stack.m_150930_(Items.f_42687_)) {
            evt.addCapability(DATA_ITEM_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.DATUM, () -> new StaticDatumHolder(s -> SpellDatum.make((Object)(Math.PI * (double)s.m_41613_())), stack)));
        }
        item = stack.m_41720_();
        if (item instanceof HexHolderItem) {
            holder = (HexHolderItem)item;
            evt.addCapability(SPELL_HOLDER_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.STORED_HEX, () -> ForgeCapabilityHandler.lambda$attachItemCaps$7((HexHolderItem)holder, stack)));
        }
        if ((item = stack.m_41720_()) instanceof ColorizerItem) {
            ColorizerItem colorizer = (ColorizerItem)item;
            evt.addCapability(COLORIZER_CAPABILITY, ForgeCapabilityHandler.provide(stack, HexCapabilities.COLOR, () -> new ItemBasedColorizer(colorizer, stack)));
        }
    }

    public static void attachBlockEntityCaps(AttachCapabilitiesEvent<BlockEntity> evt) {
        Object object = evt.getObject();
        if (object instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus impetus = (BlockEntityAbstractImpetus)((Object)object);
            evt.addCapability(IMPETUS_HANDLER, ForgeCapabilityHandler.provide(impetus, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, () -> new ForgeImpetusCapability(impetus)));
        }
    }

    private static <CAP> SimpleProvider<CAP> provide(BlockEntity be, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((BlockEntity)be).m_58901_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(ItemStack stack, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((ItemStack)stack).m_41619_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(BooleanSupplier invalidated, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return new SimpleProvider<CAP>(invalidated, capability, LazyOptional.of(supplier));
    }

    private static /* synthetic */ HexHolder lambda$attachItemCaps$7(HexHolderItem holder, ItemStack stack) {
        return new ItemBasedHexHolder(holder, stack);
    }

    private static /* synthetic */ DataHolder lambda$attachItemCaps$4(DataHolderItem holder, ItemStack stack) {
        return new ItemBasedDataHolder(holder, stack);
    }

    private static /* synthetic */ ManaHolder lambda$attachItemCaps$0(ManaHolderItem holder, ItemStack stack) {
        return new ItemBasedManaHolder(holder, stack);
    }

    private record SimpleProvider<CAP>(BooleanSupplier invalidated, Capability<CAP> capability, LazyOptional<CAP> instance) implements ICapabilityProvider
    {
        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (this.invalidated.getAsBoolean()) {
                return LazyOptional.empty();
            }
            return cap == this.capability ? this.instance.cast() : LazyOptional.empty();
        }
    }

    private record ItemBasedColorizer(ColorizerItem holder, ItemStack stack) implements Colorizer
    {
        @Override
        public int color(UUID owner, float time, Vec3 position) {
            return this.holder.color(this.stack, owner, time, position);
        }
    }

    private record ItemBasedHexHolder(HexHolderItem holder, ItemStack stack) implements HexHolder
    {
        @Override
        public boolean canDrawManaFromInventory() {
            return this.holder.canDrawManaFromInventory(this.stack);
        }

        @Override
        public boolean hasHex() {
            return this.holder.hasHex(this.stack);
        }

        @Override
        @Nullable
        public List<SpellDatum<?>> getHex(ServerLevel level) {
            return this.holder.getHex(this.stack, level);
        }

        @Override
        public void writeHex(List<SpellDatum<?>> patterns, int mana) {
            this.holder.writeHex(this.stack, patterns, mana);
        }

        @Override
        public void clearHex() {
            this.holder.clearHex(this.stack);
        }
    }

    private record StaticDatumHolder(Function<ItemStack, SpellDatum<?>> provider, ItemStack stack) implements DataHolder
    {
        @Override
        @Nullable
        public CompoundTag readRawDatum() {
            SpellDatum<?> datum = this.provider.apply(this.stack);
            return datum == null ? null : datum.serializeToNBT();
        }

        @Override
        @Nullable
        public SpellDatum<?> readDatum(ServerLevel world) {
            return this.provider.apply(this.stack);
        }

        @Override
        public boolean writeDatum(@Nullable SpellDatum<?> datum, boolean simulate) {
            return false;
        }
    }

    private record ItemBasedDataHolder(DataHolderItem holder, ItemStack stack) implements DataHolder
    {
        @Override
        @Nullable
        public CompoundTag readRawDatum() {
            return this.holder.readDatumTag(this.stack);
        }

        @Override
        @Nullable
        public SpellDatum<?> readDatum(ServerLevel world) {
            return this.holder.readDatum(this.stack, world);
        }

        @Override
        @Nullable
        public SpellDatum<?> emptyDatum() {
            return this.holder.emptyDatum(this.stack);
        }

        @Override
        public boolean writeDatum(@Nullable SpellDatum<?> datum, boolean simulate) {
            if (!this.holder.canWrite(this.stack, datum)) {
                return false;
            }
            if (!simulate) {
                this.holder.writeDatum(this.stack, datum);
            }
            return true;
        }
    }

    private record StaticManaHolder(Supplier<Integer> baseWorth, int consumptionPriority, ItemStack stack) implements ManaHolder
    {
        @Override
        public int getMana() {
            return this.baseWorth.get() * this.stack.m_41613_();
        }

        @Override
        public int getMaxMana() {
            return this.getMana();
        }

        @Override
        public void setMana(int mana) {
        }

        @Override
        public boolean canRecharge() {
            return false;
        }

        @Override
        public boolean canProvide() {
            return true;
        }

        @Override
        public int getConsumptionPriority() {
            return this.consumptionPriority;
        }

        @Override
        public boolean canConstructBattery() {
            return true;
        }

        @Override
        public int withdrawMana(int cost, boolean simulate) {
            int worth = this.baseWorth.get();
            if (cost < 0) {
                cost = worth * this.stack.m_41613_();
            }
            double itemsRequired = (double)cost / (double)worth;
            int itemsUsed = Math.min((int)Math.ceil(itemsRequired), this.stack.m_41613_());
            if (!simulate) {
                this.stack.m_41774_(itemsUsed);
            }
            return itemsUsed * worth;
        }
    }

    private record ItemBasedManaHolder(ManaHolderItem holder, ItemStack stack) implements ManaHolder
    {
        @Override
        public int getMana() {
            return this.holder.getMana(this.stack);
        }

        @Override
        public int getMaxMana() {
            return this.holder.getMaxMana(this.stack);
        }

        @Override
        public void setMana(int mana) {
            this.holder.setMana(this.stack, mana);
        }

        @Override
        public boolean canRecharge() {
            return this.holder.canRecharge(this.stack);
        }

        @Override
        public boolean canProvide() {
            return this.holder.manaProvider(this.stack);
        }

        @Override
        public int getConsumptionPriority() {
            return 40;
        }

        @Override
        public boolean canConstructBattery() {
            return false;
        }

        @Override
        public int withdrawMana(int cost, boolean simulate) {
            return this.holder.withdrawMana(this.stack, cost, simulate);
        }
    }
}

