/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen.recipe.builders;

import at.petrak.hexcasting.common.recipe.HexRecipeSerializers;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import at.petrak.hexcasting.common.recipe.ingredient.VillagerIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BrainsweepRecipeBuilder
implements RecipeBuilder {
    private StateIngredient blockIn;
    private VillagerIngredient villagerIn;
    private final BlockState result;
    private final Advancement.Builder advancement;

    public BrainsweepRecipeBuilder(StateIngredient blockIn, VillagerIngredient villagerIn, BlockState result) {
        this.blockIn = blockIn;
        this.villagerIn = villagerIn;
        this.result = result;
        this.advancement = Advancement.Builder.m_138353_();
    }

    public RecipeBuilder m_142284_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_142409_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result.m_60734_().m_5456_();
    }

    public void m_142700_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pRecipeId);
        }
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.blockIn, this.villagerIn, this.result, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/brainsweep/" + pRecipeId.m_135815_())));
    }

    public record Result(ResourceLocation id, StateIngredient blockIn, VillagerIngredient villagerIn, BlockState result, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.add("blockIn", (JsonElement)this.blockIn.serialize());
            json.add("villagerIn", (JsonElement)this.villagerIn.serialize());
            json.add("result", (JsonElement)StateIngredientHelper.serializeBlockState(this.result));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return HexRecipeSerializers.BRAINSWEEP;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

