/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.common.recipe.HexRecipeSerializers;
import at.petrak.hexcasting.common.recipe.RecipeSerializerBase;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import at.petrak.hexcasting.common.recipe.ingredient.VillagerIngredient;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public record BrainsweepRecipe(ResourceLocation id, StateIngredient blockIn, VillagerIngredient villagerIn, BlockState result) implements Recipe<Container>
{
    public boolean matches(BlockState blockIn, Villager villagerIn) {
        return this.blockIn.test(blockIn) && this.villagerIn.test(villagerIn);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return HexRecipeSerializers.BRAINSWEEP_TYPE;
    }

    public RecipeSerializer<?> m_7707_() {
        return HexRecipeSerializers.BRAINSWEEP;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container pContainer) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_.m_41777_();
    }

    public static BlockState copyProperties(BlockState original, BlockState copyTo) {
        for (Property prop : original.m_61147_()) {
            if (!copyTo.m_61138_(prop)) continue;
            copyTo = (BlockState)copyTo.m_61124_(prop, original.m_61143_(prop));
        }
        return copyTo;
    }

    public static class Serializer
    extends RecipeSerializerBase<BrainsweepRecipe> {
        @NotNull
        public BrainsweepRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            StateIngredient blockIn = StateIngredientHelper.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"blockIn"));
            VillagerIngredient villagerIn = VillagerIngredient.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"villagerIn"));
            BlockState result = StateIngredientHelper.readBlockState(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new BrainsweepRecipe(recipeID, blockIn, villagerIn, result);
        }

        public void toNetwork(FriendlyByteBuf buf, BrainsweepRecipe recipe) {
            recipe.blockIn.write(buf);
            recipe.villagerIn.write(buf);
            buf.m_130130_(Block.m_49956_((BlockState)recipe.result));
        }

        @NotNull
        public BrainsweepRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buf) {
            StateIngredient blockIn = StateIngredientHelper.read(buf);
            VillagerIngredient villagerIn = VillagerIngredient.read(buf);
            BlockState result = Block.m_49803_((int)buf.m_130242_());
            return new BrainsweepRecipe(recipeID, blockIn, villagerIn, result);
        }
    }
}

