/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;

public class HexParticles {
    private static final Map<ResourceLocation, ParticleType<?>> PARTICLES = new LinkedHashMap();
    public static final ConjureParticleOptions.Type CONJURE_PARTICLE = HexParticles.register("conjure_block_particle", new ConjureParticleOptions.Type(false));
    public static final ConjureParticleOptions.Type LIGHT_PARTICLE = HexParticles.register("conjure_light_particle", new ConjureParticleOptions.Type(false));

    public static void registerParticles(BiConsumer<ParticleType<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, ParticleType<?>> e : PARTICLES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <O extends ParticleOptions, T extends ParticleType<O>> T register(String id, T particle) {
        ParticleType<?> old = PARTICLES.put(HexAPI.modLoc(id), particle);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return particle;
    }
}

