/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemManaHolder;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ItemPackagedHex
extends ItemManaHolder
implements HexHolderItem {
    public static final String TAG_PATTERNS = "patterns";
    public static final ResourceLocation HAS_PATTERNS_PRED = HexAPI.modLoc("has_patterns");

    public ItemPackagedHex(Item.Properties pProperties) {
        super(pProperties);
    }

    public abstract boolean breakAfterDepletion();

    @Override
    public boolean canRecharge(ItemStack stack) {
        return !this.breakAfterDepletion();
    }

    @Override
    public boolean manaProvider(ItemStack stack) {
        return false;
    }

    @Override
    public boolean hasHex(ItemStack stack) {
        return NBTHelper.hasList((ItemStack)stack, (String)TAG_PATTERNS, (byte)10);
    }

    @Override
    @Nullable
    public List<SpellDatum<?>> getHex(ItemStack stack, ServerLevel level) {
        ListTag patsTag = NBTHelper.getList((ItemStack)stack, (String)TAG_PATTERNS, (int)10);
        if (patsTag == null) {
            return null;
        }
        ArrayList out = new ArrayList();
        for (Tag patTag : patsTag) {
            CompoundTag tag = NBTHelper.getAsCompound((Tag)patTag);
            if (tag.m_128440_() != 1) {
                out.add(SpellDatum.make((Object)HexPattern.fromNBT((CompoundTag)tag)));
                continue;
            }
            out.add(SpellDatum.fromNBT((CompoundTag)tag, (ServerLevel)level));
        }
        return out;
    }

    @Override
    public void writeHex(ItemStack stack, List<SpellDatum<?>> patterns, int mana) {
        ListTag patsTag = new ListTag();
        for (SpellDatum<?> pat : patterns) {
            patsTag.add((Object)pat.serializeToNBT());
        }
        NBTHelper.putList((ItemStack)stack, (String)TAG_PATTERNS, (ListTag)patsTag);
        ItemPackagedHex.withMana(stack, mana, mana);
    }

    @Override
    public void clearHex(ItemStack stack) {
        NBTHelper.remove((ItemStack)stack, (String)TAG_PATTERNS);
        NBTHelper.remove((ItemStack)stack, (String)"hexcasting:mana");
        NBTHelper.remove((ItemStack)stack, (String)"hexcasting:start_mana");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!this.hasHex(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (world.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        List<SpellDatum<?>> instrs = this.getHex(stack, (ServerLevel)world);
        if (instrs == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        CastingContext ctx = new CastingContext(sPlayer, usedHand);
        CastingHarness harness = new CastingHarness(ctx);
        ControllerInfo info = harness.executeIotas(instrs, sPlayer.m_183503_());
        boolean broken = this.breakAfterDepletion() && this.getMana(stack) == 0;
        Stat stat = broken ? Stats.f_12983_.m_12902_((Object)this) : Stats.f_12982_.m_12902_((Object)this);
        player.m_36246_(stat);
        sPlayer.m_36335_().m_41524_((Item)this, 5);
        if (info.getMakesCastSound()) {
            sPlayer.f_19853_.m_6263_(null, sPlayer.m_20185_(), sPlayer.m_20186_(), sPlayer.m_20189_(), HexSounds.ACTUALLY_CAST, SoundSource.PLAYERS, 1.0f, 1.0f + ((float)Math.random() - 0.5f) * 0.2f);
        }
        if (broken) {
            stack.m_41774_(1);
            player.m_21190_(usedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public int m_8105_(ItemStack pStack) {
        return 16;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }
}

