/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ItemManaHolder
extends Item
implements ManaHolderItem {
    public static final String TAG_MANA = "hexcasting:mana";
    public static final String TAG_MAX_MANA = "hexcasting:start_mana";

    public ItemManaHolder(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack withMana(ItemStack stack, int mana, int maxMana) {
        Item item = stack.m_41720_();
        if (item instanceof ItemManaHolder) {
            NBTHelper.putInt((ItemStack)stack, (String)TAG_MANA, (int)mana);
            NBTHelper.putInt((ItemStack)stack, (String)TAG_MAX_MANA, (int)maxMana);
        }
        return stack;
    }

    @Override
    public int getMana(ItemStack stack) {
        return NBTHelper.getInt((ItemStack)stack, (String)TAG_MANA);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return NBTHelper.getInt((ItemStack)stack, (String)TAG_MAX_MANA);
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
        NBTHelper.putInt((ItemStack)stack, (String)TAG_MANA, (int)Mth.m_14045_((int)mana, (int)0, (int)this.getMaxMana(stack)));
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.getMaxMana(pStack) > 0;
    }

    public int m_142159_(ItemStack pStack) {
        int mana = this.getMana(pStack);
        int maxMana = this.getMaxMana(pStack);
        return ManaHelper.manaBarColor((int)mana, (int)maxMana);
    }

    public int m_142158_(ItemStack pStack) {
        int mana = this.getMana(pStack);
        int maxMana = this.getMaxMana(pStack);
        return ManaHelper.manaBarWidth((int)mana, (int)maxMana);
    }

    public boolean m_41465_() {
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (pIsAdvanced.m_7050_() && this.getMaxMana(pStack) > 0) {
            pTooltipComponents.add((Component)new TranslatableComponent("item.hexcasting.manaholder.amount", new Object[]{String.format("%,d", this.getMana(pStack)), String.format("%,d", this.getMaxMana(pStack)), Float.valueOf(100.0f * this.getManaFullness(pStack))}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

