/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemCreativeUnlocker
extends Item
implements ManaHolderItem {
    private static final String TAG_EXTRACTIONS = "extractions";
    private static final TextColor HEX_COLOR = TextColor.m_131266_((int)11767539);

    public static boolean isDebug(ItemStack stack) {
        return stack.m_150930_((Item)HexItems.CREATIVE_UNLOCKER) && stack.m_41786_().getString().toLowerCase(Locale.ROOT).equals("debug");
    }

    public ItemCreativeUnlocker(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getMana(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
    }

    @Override
    public boolean manaProvider(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canRecharge(ItemStack stack) {
        return false;
    }

    @Override
    public int withdrawMana(ItemStack stack, int cost, boolean simulate) {
        if (!simulate && ItemCreativeUnlocker.isDebug(stack)) {
            int[] arr = NBTHelper.getIntArray((ItemStack)stack, (String)TAG_EXTRACTIONS);
            if (arr == null) {
                arr = new int[]{};
            }
            int[] newArr = Arrays.copyOf(arr, arr.length + 1);
            newArr[newArr.length - 1] = cost;
            NBTHelper.putIntArray((ItemStack)stack, (String)TAG_EXTRACTIONS, (int[])newArr);
        }
        return cost < 0 ? 1 : cost;
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || ItemCreativeUnlocker.isDebug(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        int[] arr;
        if (ItemCreativeUnlocker.isDebug(stack) && !level.f_46443_ && (arr = NBTHelper.getIntArray((ItemStack)stack, (String)TAG_EXTRACTIONS)) != null) {
            NBTHelper.remove((ItemStack)stack, (String)TAG_EXTRACTIONS);
            for (int i : arr) {
                if (i < 0) {
                    entity.m_6352_((Component)new TranslatableComponent("hexcasting.debug.mana_withdrawn", new Object[]{stack.m_41611_(), new TranslatableComponent("hexcasting.debug.all_mana").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.LIGHT_PURPLE), Util.f_137441_);
                    continue;
                }
                entity.m_6352_((Component)new TranslatableComponent("hexcasting.debug.mana_withdrawn.with_dust", new Object[]{stack.m_41611_(), new TextComponent("" + i).m_130940_(ChatFormatting.WHITE), new TextComponent(String.format("%.2f", (double)i * 1.0 / 10000.0)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.LIGHT_PURPLE), Util.f_137441_);
            }
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (consumer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)consumer;
                Advancement rootAdv = slevel.m_142572_().m_129889_().m_136041_(HexAPI.modLoc("root"));
                if (rootAdv != null) {
                    ArrayList<Advancement> children = new ArrayList<Advancement>();
                    children.add(rootAdv);
                    ItemCreativeUnlocker.addChildren(rootAdv, children);
                    PlayerAdvancements adman = player.m_8960_();
                    for (Advancement kid : children) {
                        AdvancementProgress progress = adman.m_135996_(kid);
                        if (progress.m_8193_()) continue;
                        for (String crit : progress.m_8219_()) {
                            adman.m_135988_(kid, crit);
                        }
                    }
                }
            }
        }
        ItemStack copy = stack.m_41777_();
        super.m_5922_(stack, level, consumer);
        return copy;
    }

    private static MutableComponent rainbow(MutableComponent component, int shift, Level level) {
        if (level == null) {
            return component.m_130940_(ChatFormatting.WHITE);
        }
        return component.m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)Mth.m_14169_((float)((float)((level.m_46467_() + (long)shift) * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f))));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        String prefix = "item.hexcasting.creative_unlocker.";
        String emphasis = Language.m_128107_().m_6834_(prefix + "for_emphasis");
        TextComponent emphasized = new TextComponent("");
        for (int i = 0; i < emphasis.length(); ++i) {
            emphasized.m_7220_((Component)ItemCreativeUnlocker.rainbow((MutableComponent)new TextComponent("" + emphasis.charAt(i)), i, level));
        }
        MutableComponent modName = new TranslatableComponent(prefix + "mod_name").m_130938_(s -> s.m_131148_(HEX_COLOR));
        tooltipComponents.add((Component)new TranslatableComponent(prefix + "tooltip.0", new Object[]{emphasized}).m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)new TranslatableComponent(prefix + "tooltip.1", new Object[]{modName}).m_130940_(ChatFormatting.GRAY));
    }

    private static void addChildren(Advancement root, List<Advancement> out) {
        for (Advancement kiddo : root.m_138322_()) {
            out.add(kiddo);
            ItemCreativeUnlocker.addChildren(kiddo, out);
        }
    }
}

