/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipGreeble;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemSlate
extends BlockItem
implements DataHolderItem {
    public static final ResourceLocation WRITTEN_PRED = HexAPI.modLoc("written");

    public ItemSlate(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public Component m_7626_(ItemStack pStack) {
        String key = "block.hexcasting.slate." + (ItemSlate.hasPattern(pStack) ? "written" : "blank");
        return new TranslatableComponent(key);
    }

    public static boolean hasPattern(ItemStack stack) {
        CompoundTag bet = NBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag");
        if (bet != null) {
            return bet.m_128425_("pattern", 10) && !bet.m_128469_("pattern").m_128456_();
        }
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!ItemSlate.hasPattern(stack)) {
            NBTHelper.remove((ItemStack)stack, (String)"BlockEntityTag");
        }
        return false;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!ItemSlate.hasPattern(pStack)) {
            NBTHelper.remove((ItemStack)pStack, (String)"BlockEntityTag");
        }
    }

    @Override
    @Nullable
    public CompoundTag readDatumTag(ItemStack stack) {
        CompoundTag bet = NBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag");
        if (bet == null || !bet.m_128425_("pattern", 10)) {
            return null;
        }
        CompoundTag patTag = bet.m_128469_("pattern");
        if (patTag.m_128456_()) {
            return null;
        }
        CompoundTag out = new CompoundTag();
        out.m_128365_("pattern", (Tag)patTag);
        return out;
    }

    @Override
    public boolean canWrite(ItemStack stack, SpellDatum<?> datum) {
        return datum == null || datum.getType() == DatumType.PATTERN;
    }

    @Override
    public void writeDatum(ItemStack stack, SpellDatum<?> datum) {
        if (this.canWrite(stack, datum)) {
            if (datum == null) {
                CompoundTag beTag = NBTHelper.getOrCreateCompound((ItemStack)stack, (String)"BlockEntityTag");
                beTag.m_128473_("pattern");
                if (beTag.m_128456_()) {
                    NBTHelper.remove((ItemStack)stack, (String)"BlockEntityTag");
                }
            } else {
                Object beTag = datum.getPayload();
                if (beTag instanceof HexPattern) {
                    HexPattern pat = (HexPattern)beTag;
                    beTag = NBTHelper.getOrCreateCompound((ItemStack)stack, (String)"BlockEntityTag");
                    beTag.m_128365_("pattern", (Tag)pat.serializeToNBT());
                }
            }
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        CompoundTag patTag;
        CompoundTag bet = NBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag");
        if (bet != null && bet.m_128425_("pattern", 10) && !(patTag = bet.m_128469_("pattern")).m_128456_()) {
            HexPattern pattern = HexPattern.fromNBT((CompoundTag)patTag);
            return Optional.of(new PatternTooltipGreeble(pattern, PatternTooltipGreeble.SLATE_BG));
        }
        return Optional.empty();
    }
}

