/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipGreeble;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class ItemScroll
extends Item
implements DataHolderItem {
    public static final String TAG_OP_ID = "op_id";
    public static final String TAG_PATTERN = "pattern";
    public static final ResourceLocation ANCIENT_PREDICATE = HexAPI.modLoc("ancient");
    public final int blockSize;

    public ItemScroll(Item.Properties pProperties, int blockSize) {
        super(pProperties);
        this.blockSize = blockSize;
    }

    @Override
    @Nullable
    public CompoundTag readDatumTag(ItemStack stack) {
        CompoundTag pattern = NBTHelper.getCompound((ItemStack)stack, (String)TAG_PATTERN);
        if (pattern == null) {
            return null;
        }
        CompoundTag out = new CompoundTag();
        out.m_128365_(TAG_PATTERN, (Tag)pattern);
        return out;
    }

    @Override
    public boolean canWrite(ItemStack stack, SpellDatum<?> datum) {
        return datum != null && datum.getType() == DatumType.PATTERN && !NBTHelper.hasCompound((ItemStack)stack, (String)TAG_PATTERN);
    }

    @Override
    public void writeDatum(ItemStack stack, SpellDatum<?> datum) {
        Object object;
        if (this.canWrite(stack, datum) && (object = datum.getPayload()) instanceof HexPattern) {
            HexPattern pat = (HexPattern)object;
            NBTHelper.putCompound((ItemStack)stack, (String)TAG_PATTERN, (CompoundTag)pat.serializeToNBT());
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos posClicked = ctx.m_8083_();
        Direction direction = ctx.m_43719_();
        BlockPos posInFront = posClicked.m_142300_(direction);
        Player player = ctx.m_43723_();
        ItemStack itemstack = ctx.m_43722_();
        if (player != null && !this.mayPlace(player, direction, itemstack, posInFront)) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.m_43725_();
        ItemStack scrollStack = itemstack.m_41777_();
        scrollStack.m_41764_(1);
        EntityWallScroll scrollEntity = new EntityWallScroll(level, posInFront, direction, scrollStack, false, this.blockSize);
        CompoundTag stackTag = itemstack.m_41783_();
        if (stackTag != null) {
            EntityType.m_20620_((Level)level, (Player)player, (Entity)scrollEntity, (CompoundTag)stackTag);
        }
        if (scrollEntity.m_7088_()) {
            if (!level.f_46443_) {
                scrollEntity.m_7084_();
                level.m_142346_((Entity)player, GameEvent.f_157810_, posClicked);
                level.m_7967_((Entity)scrollEntity);
            }
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player pPlayer, Direction pDirection, ItemStack pHangingEntityStack, BlockPos pPos) {
        return !pDirection.m_122434_().m_122478_() && pPlayer.m_36204_(pPos, pDirection, pHangingEntityStack);
    }

    public Component m_7626_(ItemStack pStack) {
        String descID = this.m_5671_(pStack);
        String ancientId = NBTHelper.getString((ItemStack)pStack, (String)TAG_OP_ID);
        if (ancientId != null) {
            return new TranslatableComponent(descID + ".of", new Object[]{new TranslatableComponent("hexcasting.spell." + ResourceLocation.m_135820_((String)ancientId))});
        }
        if (NBTHelper.hasCompound((ItemStack)pStack, (String)TAG_PATTERN)) {
            return new TranslatableComponent(descID);
        }
        return new TranslatableComponent(descID + ".empty");
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        CompoundTag compound = NBTHelper.getCompound((ItemStack)stack, (String)TAG_PATTERN);
        if (compound != null) {
            HexPattern pattern = HexPattern.fromNBT((CompoundTag)compound);
            return Optional.of(new PatternTooltipGreeble(pattern, NBTHelper.hasString((ItemStack)stack, (String)TAG_OP_ID) ? PatternTooltipGreeble.ANCIENT_BG : PatternTooltipGreeble.PRISTINE_BG));
        }
        return Optional.empty();
    }
}

