/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.common.network.MsgUpdateComparatorVisualsAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Wearable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemLens
extends Item
implements Wearable {
    private static final Map<ServerPlayer, Pair<BlockPos, Integer>> comparatorDataMap = new WeakHashMap<ServerPlayer, Pair<BlockPos, Integer>>();

    public ItemLens(Item.Properties pProperties) {
        super(pProperties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack m_7498_(@NotNull BlockSource world, @NotNull ItemStack stack) {
                this.m_123573_(ArmorItem.m_40398_((BlockSource)world, (ItemStack)stack));
                return stack;
            }
        });
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
        ItemStack stack = player.m_6844_(equipmentslot);
        if (stack.m_41619_()) {
            player.m_8061_(equipmentslot, itemstack.m_41777_());
            if (!world.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemstack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        ServerPlayer player;
        if (!pLevel.m_5776_() && pEntity instanceof ServerPlayer && (pStack == (player = (ServerPlayer)pEntity).m_6844_(EquipmentSlot.HEAD) || pStack == player.m_6844_(EquipmentSlot.MAINHAND) || pStack == player.m_6844_(EquipmentSlot.OFFHAND))) {
            this.sendComparatorDataToClient(player);
        }
    }

    private void sendComparatorDataToClient(ServerPlayer player) {
        double reachAttribute = IXplatAbstractions.INSTANCE.getReachDistance((Player)player);
        double distance = player.m_7500_() ? reachAttribute : reachAttribute - 0.5;
        HitResult hitResult = player.m_19907_(distance, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hitResult).m_82425_();
            BlockState state = player.f_19853_.m_8055_(pos);
            if (state.m_60713_(Blocks.f_50328_)) {
                this.syncComparatorValue(player, pos, state.m_60775_((BlockGetter)player.f_19853_, pos, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            } else if (state.m_60807_()) {
                this.syncComparatorValue(player, pos, state.m_60674_(player.f_19853_, pos));
            } else {
                this.syncComparatorValue(player, null, -1);
            }
        } else {
            this.syncComparatorValue(player, null, -1);
        }
    }

    private void syncComparatorValue(ServerPlayer player, BlockPos pos, int value) {
        Pair<BlockPos, Integer> previous = comparatorDataMap.get(player);
        if (value == -1) {
            if (previous != null) {
                comparatorDataMap.remove(player);
                IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgUpdateComparatorVisualsAck(null, -1));
            }
        } else if (previous == null || !pos.equals(previous.getFirst()) || value != (Integer)previous.getSecond()) {
            comparatorDataMap.put(player, (Pair<BlockPos, Integer>)new Pair((Object)pos, (Object)value));
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgUpdateComparatorVisualsAck(pos, value));
        }
    }

    @Nullable
    public SoundEvent m_142602_() {
        return SoundEvents.f_144243_;
    }
}

