/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityStoredPlayerImpetus
extends BlockEntityAbstractImpetus {
    public static final String TAG_STORED_PLAYER = "stored_player";
    public static final String TAG_STORED_PLAYER_NAME = "stored_player_name";
    private String storedPlayerName = null;
    private UUID storedPlayer = null;

    public BlockEntityStoredPlayerImpetus(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.IMPETUS_STOREDPLAYER_TILE, pWorldPosition, pBlockState);
    }

    @Override
    public boolean activatorAlwaysInRange() {
        return true;
    }

    @Override
    @Nullable
    protected Player getPlayer() {
        return this.storedPlayer == null ? null : this.f_58857_.m_46003_(this.storedPlayer);
    }

    @Nullable
    protected String getPlayerName() {
        Player player = this.getStoredPlayer();
        if (player != null) {
            return player.m_6302_();
        }
        return this.storedPlayerName;
    }

    public void setPlayer(String name, UUID player) {
        this.storedPlayerName = name;
        this.storedPlayer = player;
        this.m_6596_();
    }

    public void updatePlayerName() {
        String newName;
        Player player = this.getStoredPlayer();
        if (player != null && !(newName = player.m_6302_()).equals(this.storedPlayerName)) {
            this.storedPlayerName = newName;
            this.m_6596_();
        }
    }

    @Nullable
    public Player getStoredPlayer() {
        return this.getPlayer();
    }

    @Override
    public void applyScryingLensOverlay(List<Pair<ItemStack, Component>> lines, BlockState state, BlockPos pos, LocalPlayer observer, ClientLevel world, Direction hitFace, InteractionHand lensHand) {
        super.applyScryingLensOverlay(lines, state, pos, observer, world, hitFace, lensHand);
        String name = this.getPlayerName();
        if (name != null) {
            ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
            NBTHelper.putString((ItemStack)head, (String)"SkullOwner", (String)name);
            lines.add((Pair<ItemStack, Component>)new Pair((Object)head, (Object)new TranslatableComponent("hexcasting.tooltip.lens.impetus.storedplayer", new Object[]{name})));
        } else {
            lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)Items.f_42127_), (Object)new TranslatableComponent("hexcasting.tooltip.lens.impetus.storedplayer.none")));
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        super.saveModData(tag);
        if (this.storedPlayer != null) {
            tag.m_128362_(TAG_STORED_PLAYER, this.storedPlayer);
        }
        if (this.storedPlayerName != null) {
            tag.m_128359_(TAG_STORED_PLAYER_NAME, this.storedPlayerName);
        }
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        super.loadModData(tag);
        this.storedPlayer = tag.m_128425_(TAG_STORED_PLAYER, 11) ? tag.m_128342_(TAG_STORED_PLAYER) : null;
        if (tag.m_128425_(TAG_STORED_PLAYER_NAME, 8)) {
            this.storedPlayerName = tag.m_128461_(TAG_STORED_PLAYER_NAME);
        } else {
            this.storedPlayer = null;
        }
    }
}

