/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles.directrix;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import com.mojang.math.Vector3f;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockRedstoneDirectrix
extends BlockCircleComponent {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty REDSTONE_POWERED = BlockStateProperties.f_61448_;

    public BlockRedstoneDirectrix(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)REDSTONE_POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ENERGIZED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public boolean canEnterFromDirection(Direction enterDir, Direction normalDir, BlockPos pos, BlockState bs, Level world) {
        return enterDir != this.getRealFacing(bs);
    }

    @Override
    public EnumSet<Direction> exitDirections(BlockPos pos, BlockState bs, Level world) {
        return EnumSet.of(this.getRealFacing(bs));
    }

    @Override
    @Nullable
    public HexPattern getPattern(BlockPos pos, BlockState bs, Level world) {
        return null;
    }

    @Override
    public Direction normalDir(BlockPos pos, BlockState bs, Level world, int recursionLeft) {
        return BlockRedstoneDirectrix.normalDirOfOther(pos.m_142300_(this.getRealFacing(bs)), world, recursionLeft);
    }

    @Override
    public float particleHeight(BlockPos pos, BlockState bs, Level world) {
        return 0.5f;
    }

    protected Direction getRealFacing(BlockState bs) {
        Direction facing = (Direction)bs.m_61143_((Property)FACING);
        if (((Boolean)bs.m_61143_((Property)REDSTONE_POWERED)).booleanValue()) {
            return facing.m_122424_();
        }
        return facing;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean currentlyPowered;
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (!pLevel.f_46443_ && (currentlyPowered = ((Boolean)pState.m_61143_((Property)REDSTONE_POWERED)).booleanValue()) != pLevel.m_46753_(pPos)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)REDSTONE_POWERED, (Comparable)Boolean.valueOf(!currentlyPowered)), 2);
        }
    }

    public void m_7100_(BlockState bs, Level pLevel, BlockPos pos, Random rand) {
        if (((Boolean)bs.m_61143_((Property)REDSTONE_POWERED)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                Vector3f step = ((Direction)bs.m_61143_((Property)FACING)).m_122424_().m_122432_();
                Vec3 center = Vec3.m_82512_((Vec3i)pos).m_82520_((double)step.m_122239_() * 0.5, (double)step.m_122260_() * 0.5, (double)step.m_122269_() * 0.5);
                double x = center.f_82479_ + (rand.nextDouble() - 0.5) * 0.5;
                double y = center.f_82480_ + (rand.nextDouble() - 0.5) * 0.5;
                double z = center.f_82481_ + (rand.nextDouble() - 0.5) * 0.5;
                pLevel.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, (double)step.m_122239_() * 0.1, (double)step.m_122260_() * 0.1, (double)step.m_122269_() * 0.1);
            }
        }
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.BLOCK;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{REDSTONE_POWERED, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_7820_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

