/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.utils;

import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.interop.utils.PatternEntry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public final class PatternDrawingUtil {
    public static void drawPattern(PoseStack poseStack, int x, int y, List<PatternEntry> patterns, List<Vec2> dots, boolean strokeOrder, long animTicks, int outer, int innerLight, int innerDark, int dotColor) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 1.0);
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        ShaderInstance prevShader = RenderSystem.m_157196_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69464_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (PatternEntry pat : patterns) {
            RenderLib.drawLineSeq((Matrix4f)mat, pat.zappyPoints(), (float)5.0f, (float)0.0f, (int)outer, (int)outer, null);
            RenderLib.drawLineSeq((Matrix4f)mat, pat.zappyPoints(), (float)2.0f, (float)0.0f, (int)(strokeOrder ? innerDark : innerLight), (int)innerLight, strokeOrder ? Float.valueOf((float)animTicks / 20.0f) : null);
            if (!strokeOrder) continue;
            RenderLib.drawSpot((Matrix4f)mat, (Vec2)pat.zappyPoints().get(0), (float)2.5f, (float)1.0f, (float)0.1f, (float)0.15f, (float)0.6f);
        }
        float dotR = (float)FastColor.ARGB32.m_13665_((int)dotColor) / 255.0f;
        float dotG = (float)FastColor.ARGB32.m_13667_((int)dotColor) / 255.0f;
        float dotB = (float)FastColor.ARGB32.m_13669_((int)dotColor) / 255.0f;
        float dotA = (float)FastColor.ARGB32.m_13655_((int)dotColor) / 255.0f;
        for (Vec2 dot : dots) {
            RenderLib.drawSpot((Matrix4f)mat, (Vec2)dot, (float)1.5f, (float)dotR, (float)dotG, (float)dotB, (float)dotA);
        }
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(() -> prevShader);
        RenderSystem.m_69481_();
        poseStack.m_85849_();
    }

    public static PatternRenderingData loadPatterns(List<Pair<HexPattern, HexCoord>> patterns) {
        ArrayList<PatternEntry> patternEntries = new ArrayList<PatternEntry>(patterns.size());
        boolean fakeScale = true;
        ArrayList<Vec2> seenFakePoints = new ArrayList<Vec2>();
        HashSet seenCoords = new HashSet();
        for (Pair<HexPattern, HexCoord> pair : patterns) {
            HexPattern pattern = (HexPattern)pair.getFirst();
            HexCoord origin = (HexCoord)pair.getSecond();
            for (HexCoord pos : pattern.positions(origin)) {
                Vec2 px = HexUtils.coordToPx((HexCoord)pos, (float)((float)fakeScale), (Vec2)Vec2.f_82462_);
                seenFakePoints.add(px);
            }
            patternEntries.add(new PatternEntry(pattern, origin, new ArrayList<Vec2>()));
            seenCoords.addAll(pattern.positions(origin));
        }
        Vec2 fakeCom = HexUtils.findCenter(seenFakePoints);
        float maxDx = -1.0f;
        float maxDy = -1.0f;
        for (Vec2 dot : seenFakePoints) {
            float dy;
            float dx = Mth.m_14154_((float)(dot.f_82470_ - fakeCom.f_82470_));
            if (dx > maxDx) {
                maxDx = dx;
            }
            if (!((dy = Mth.m_14154_((float)(dot.f_82471_ - fakeCom.f_82471_))) > maxDy)) continue;
            maxDy = dy;
        }
        float hexSize = Math.min(12.0f, Math.min(48.0f / maxDx, 28.0f / maxDy));
        ArrayList<Vec2> seenRealPoints = new ArrayList<Vec2>();
        for (PatternEntry pat : patternEntries) {
            for (HexCoord pos : pat.pattern().positions(pat.origin())) {
                Vec2 px = HexUtils.coordToPx((HexCoord)pos, (float)hexSize, (Vec2)Vec2.f_82462_);
                seenRealPoints.add(px);
            }
        }
        Vec2 realCom = HexUtils.findCenter(seenRealPoints);
        for (PatternEntry pat : patternEntries) {
            Vec2 localOrigin = HexUtils.coordToPx((HexCoord)pat.origin(), (float)hexSize, (Vec2)realCom.m_165913_());
            List points = pat.pattern().toLines(hexSize, localOrigin);
            pat.zappyPoints().addAll(RenderLib.makeZappy((List)points, (float)10.0f, (float)0.8f, (float)0.0f, (float)0.0f));
        }
        List<Vec2> pathfinderDots = seenCoords.stream().map(coord -> HexUtils.coordToPx((HexCoord)coord, (float)hexSize, (Vec2)realCom.m_165913_())).toList();
        return new PatternRenderingData(patternEntries, pathfinderDots, hexSize);
    }

    public record PatternRenderingData(List<PatternEntry> patterns, List<Vec2> pathfinderDots, float hexSize) {
    }
}

