/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.recipe;

import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.NBTIngredient;
import org.jetbrains.annotations.NotNull;

public class ForgeUnsealedIngredient
extends AbstractIngredient {
    private final ItemStack stack;

    protected ForgeUnsealedIngredient(ItemStack stack) {
        super(Arrays.stream(DatumType.values()).filter(it -> it != DatumType.EMPTY && it != DatumType.OTHER).map(type -> {
            ItemStack newStack = stack.m_41777_();
            NBTHelper.putString((ItemStack)newStack, (String)"VisualOverride", (String)SpellDatum.tagForType((DatumType)((Object)type)));
            return new Ingredient.ItemValue(newStack);
        }));
        this.stack = stack;
    }

    public static ForgeUnsealedIngredient of(ItemStack stack) {
        return new ForgeUnsealedIngredient(stack);
    }

    public boolean test(@Nullable ItemStack input) {
        DataHolder holder;
        if (input == null) {
            return false;
        }
        if (this.stack.m_41720_() == input.m_41720_() && this.stack.m_41773_() == input.m_41773_() && (holder = IXplatAbstractions.INSTANCE.findDataHolder(this.stack)) != null) {
            return holder.readRawDatum() != null && holder.writeDatum(SpellDatum.make((Object)Widget.NULL), true);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.toString(CraftingHelper.getID((IIngredientSerializer)NBTIngredient.Serializer.INSTANCE)));
        json.addProperty("item", Objects.toString(this.stack.m_41720_().getRegistryName()));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<ForgeUnsealedIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public ForgeUnsealedIngredient parse(FriendlyByteBuf buffer) {
            return new ForgeUnsealedIngredient(buffer.m_130267_());
        }

        @NotNull
        public ForgeUnsealedIngredient parse(@NotNull JsonObject json) {
            return new ForgeUnsealedIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(FriendlyByteBuf buffer, ForgeUnsealedIngredient ingredient) {
            buffer.m_130055_(ingredient.stack);
        }
    }
}

