/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.interop.jei;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.interop.utils.PatternDrawingUtil;
import at.petrak.hexcasting.interop.utils.PatternEntry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class PatternDrawable
implements IDrawable {
    private final long startTime = System.currentTimeMillis();
    private final int width;
    private final int height;
    private final boolean strokeOrder;
    private final List<PatternEntry> patterns;
    private final List<Vec2> pathfinderDots;

    public PatternDrawable(ResourceLocation pattern, int w, int h) {
        PatternRegistry.PatternEntry entry = PatternRegistry.lookupPattern((ResourceLocation)pattern);
        this.strokeOrder = !entry.isPerWorld();
        PatternDrawingUtil.PatternRenderingData data = PatternDrawingUtil.loadPatterns(List.of(new Pair((Object)entry.getPrototype(), (Object)HexCoord.getOrigin())));
        this.patterns = data.patterns();
        this.pathfinderDots = data.pathfinderDots();
        this.width = w;
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        long time = (System.currentTimeMillis() - this.startTime) / 50L;
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)xOffset - 0.5f + (float)this.width / 2.0f), (double)((float)yOffset + (float)this.height / 2.0f), 0.0);
        poseStack.m_85841_((float)this.width / 64.0f, (float)this.height / 64.0f, 1.0f);
        PatternDrawingUtil.drawPattern(poseStack, 0, 0, this.patterns, this.pathfinderDots, this.strokeOrder, time, -13422544, -15132648, -938735092, -2140773533);
        poseStack.m_85849_();
    }
}

