/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.datagen.HexAdvancements;
import at.petrak.hexcasting.datagen.HexBlockTagProvider;
import at.petrak.hexcasting.datagen.HexItemTagProvider;
import at.petrak.hexcasting.datagen.HexLootTables;
import at.petrak.hexcasting.datagen.IXplatIngredients;
import at.petrak.hexcasting.datagen.recipe.HexplatRecipes;
import at.petrak.hexcasting.forge.datagen.xplat.HexBlockStatesAndModels;
import at.petrak.hexcasting.forge.datagen.xplat.HexItemModels;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.hexcasting.xplat.IXplatTags;
import at.petrak.paucal.api.forge.datagen.PaucalForgeDatagenWrappers;
import java.util.EnumMap;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public class HexForgeDataGenerators {
    private static IXplatIngredients INGREDIENTS = new IXplatIngredients(){

        @Override
        public Ingredient glowstoneDust() {
            return Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_GLOWSTONE);
        }

        @Override
        public Ingredient leather() {
            return Ingredient.m_204132_((TagKey)Tags.Items.LEATHER);
        }

        @Override
        public Ingredient ironNugget() {
            return Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_IRON);
        }

        @Override
        public Ingredient goldNugget() {
            return Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_GOLD);
        }

        @Override
        public Ingredient copperIngot() {
            return Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER);
        }

        @Override
        public Ingredient ironIngot() {
            return Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON);
        }

        @Override
        public Ingredient goldIngot() {
            return Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD);
        }

        @Override
        public EnumMap<DyeColor, Ingredient> dyes() {
            EnumMap<DyeColor, Ingredient> out = new EnumMap<DyeColor, Ingredient>(DyeColor.class);
            for (DyeColor col : DyeColor.values()) {
                out.put(col, Ingredient.m_204132_((TagKey)col.getTag()));
            }
            return out;
        }

        @Override
        public Ingredient stick() {
            return Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42398_)), new Ingredient.TagValue(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "rods/wooden")))));
        }
    };

    @SubscribeEvent
    public static void generateData(GatherDataEvent ev) {
        if (System.getProperty("hexcasting.xplat_datagen") != null) {
            HexForgeDataGenerators.configureXplatDatagen(ev);
        }
        if (System.getProperty("hexcasting.forge_datagen") != null) {
            HexForgeDataGenerators.configureForgeDatagen(ev);
        }
    }

    private static void configureXplatDatagen(GatherDataEvent ev) {
        HexAPI.LOGGER.info("Starting cross-platform datagen");
        DataGenerator gen = ev.getGenerator();
        ExistingFileHelper efh = ev.getExistingFileHelper();
        if (ev.includeClient()) {
            gen.m_123914_((DataProvider)new HexItemModels(gen, efh));
            gen.m_123914_((DataProvider)new HexBlockStatesAndModels(gen, efh));
        }
        if (ev.includeServer()) {
            gen.m_123914_((DataProvider)PaucalForgeDatagenWrappers.addEFHToAdvancements((AdvancementProvider)new HexAdvancements(gen), (ExistingFileHelper)efh));
        }
    }

    private static void configureForgeDatagen(GatherDataEvent ev) {
        HexAPI.LOGGER.info("Starting Forge-specific datagen");
        DataGenerator gen = ev.getGenerator();
        ExistingFileHelper efh = ev.getExistingFileHelper();
        if (ev.includeServer()) {
            gen.m_123914_((DataProvider)new HexLootTables(gen));
            gen.m_123914_((DataProvider)new HexplatRecipes(gen, INGREDIENTS));
            IXplatTags xtags = IXplatAbstractions.INSTANCE.tags();
            HexBlockTagProvider blockTagProvider = (HexBlockTagProvider)PaucalForgeDatagenWrappers.addEFHToTagProvider((TagsProvider)new HexBlockTagProvider(gen, xtags), (ExistingFileHelper)efh);
            gen.m_123914_((DataProvider)blockTagProvider);
            HexItemTagProvider itemTagProvider = (HexItemTagProvider)PaucalForgeDatagenWrappers.addEFHToTagProvider((TagsProvider)new HexItemTagProvider(gen, (TagsProvider<Block>)blockTagProvider, IXplatAbstractions.INSTANCE.tags()), (ExistingFileHelper)efh);
            gen.m_123914_((DataProvider)itemTagProvider);
        }
    }
}

