/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import org.jetbrains.annotations.Nullable;

public record VillagerIngredient(@Nullable ResourceLocation profession, @Nullable ResourceLocation biome, int minLevel) implements Predicate<Villager>
{
    @Override
    public boolean test(Villager villager) {
        VillagerData data = villager.m_7141_();
        ResourceLocation profID = IXplatAbstractions.INSTANCE.getID(data.m_35571_());
        return !(this.profession != null && !this.profession.equals((Object)profID) || this.biome != null && !this.biome.equals((Object)Registry.f_122868_.m_7981_((Object)data.m_35560_())) || this.minLevel > data.m_35576_());
    }

    public Component name() {
        TextComponent component = new TextComponent("");
        boolean addedAny = false;
        if (this.minLevel >= 5) {
            component.m_7220_((Component)new TranslatableComponent("merchant.level.5"));
            addedAny = true;
        } else if (this.minLevel > 1) {
            component.m_7220_((Component)new TranslatableComponent("merchant.level." + this.minLevel));
            addedAny = true;
        } else if (this.profession != null) {
            component.m_7220_((Component)new TranslatableComponent("merchant.level.1"));
            addedAny = true;
        }
        if (this.biome != null) {
            if (addedAny) {
                component.m_130946_(" ");
            }
            component.m_7220_((Component)new TranslatableComponent("biome.minecraft." + this.biome.m_135815_()));
            addedAny = true;
        }
        if (this.profession != null) {
            component.m_130946_(" ");
            component.m_7220_((Component)new TranslatableComponent("entity.minecraft.villager." + this.profession.m_135815_()));
        } else {
            if (addedAny) {
                component.m_130946_(" ");
            }
            component.m_7220_(EntityType.f_20492_.m_20676_());
        }
        return component;
    }

    public List<Component> getTooltip(boolean advanced) {
        return this.getTooltip(advanced, true);
    }

    public List<Component> getTooltip(boolean advanced, boolean orHigher) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.name());
        if (advanced) {
            if (orHigher) {
                if (this.minLevel >= 5) {
                    tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.brainsweep.level", new Object[]{5}).m_130940_(ChatFormatting.DARK_GRAY));
                } else if (this.minLevel > 1) {
                    tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.brainsweep.min_level", new Object[]{this.minLevel}).m_130940_(ChatFormatting.DARK_GRAY));
                }
            } else if (this.profession != null || this.minLevel > 1) {
                tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.brainsweep.level", new Object[]{Mth.m_14045_((int)this.minLevel, (int)1, (int)5)}).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.biome != null) {
                tooltip.add((Component)new TextComponent(this.biome.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            ResourceLocation displayId = Objects.requireNonNullElseGet(this.profession, () -> Registry.f_122826_.m_7981_((Object)EntityType.f_20492_));
            tooltip.add((Component)new TextComponent(displayId.toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltip.add(this.getModNameComponent());
        return tooltip;
    }

    public Component getModNameComponent() {
        String namespace = this.profession == null ? "minecraft" : this.profession.m_135827_();
        String mod = IXplatAbstractions.INSTANCE.getModName(namespace);
        return new TextComponent(mod).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        if (this.profession != null) {
            obj.addProperty("profession", this.profession.toString());
        }
        if (this.biome != null) {
            obj.addProperty("biome", this.biome.toString());
        }
        obj.addProperty("minLevel", (Number)this.minLevel);
        return obj;
    }

    public void write(FriendlyByteBuf buf) {
        if (this.profession != null) {
            buf.m_130130_(1);
            buf.m_130085_(this.profession);
        } else {
            buf.m_130130_(0);
        }
        if (this.biome != null) {
            buf.m_130130_(1);
            buf.m_130085_(this.biome);
        } else {
            buf.m_130130_(0);
        }
        buf.writeInt(this.minLevel);
    }

    public static VillagerIngredient deserialize(JsonObject json) {
        ResourceLocation profession = null;
        if (json.has("profession")) {
            profession = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"profession"));
        }
        ResourceLocation biome = null;
        if (json.has("biome")) {
            biome = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"biome"));
        }
        int minLevel = GsonHelper.m_13927_((JsonObject)json, (String)"minLevel");
        return new VillagerIngredient(profession, biome, minLevel);
    }

    public static VillagerIngredient read(FriendlyByteBuf buf) {
        ResourceLocation profession = null;
        int hasProfession = buf.m_130242_();
        if (hasProfession != 0) {
            profession = buf.m_130281_();
        }
        ResourceLocation biome = null;
        int hasBiome = buf.m_130242_();
        if (hasBiome != 0) {
            biome = buf.m_130281_();
        }
        int minLevel = buf.readInt();
        return new VillagerIngredient(profession, biome, minLevel);
    }
}

