/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemSpellbook;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record MsgShiftScrollSyn(InteractionHand hand, double scrollDelta, boolean isCtrl) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("scroll");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgShiftScrollSyn deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        double scrollDelta = buf.readDouble();
        boolean isCtrl = buf.readBoolean();
        return new MsgShiftScrollSyn(hand, scrollDelta, isCtrl);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.hand);
        buf.writeDouble(this.scrollDelta);
        buf.writeBoolean(this.isCtrl);
    }

    public void handle(MinecraftServer server, ServerPlayer sender) {
        server.execute(() -> {
            ItemStack stack = sender.m_21120_(this.hand);
            if (stack.m_41720_() == HexItems.SPELLBOOK) {
                this.spellbook(sender, stack);
            } else if (stack.m_41720_() == HexItems.ABACUS) {
                this.abacus(sender, stack);
            }
        });
    }

    private void spellbook(ServerPlayer sender, ItemStack stack) {
        int newIdx = ItemSpellbook.RotatePageIdx(stack, this.scrollDelta < 0.0);
        int len = ItemSpellbook.HighestPage(stack);
        boolean sealed = ItemSpellbook.IsSealed(stack);
        TranslatableComponent component = this.hand == InteractionHand.OFF_HAND && stack.m_41788_() ? (sealed ? new TranslatableComponent("hexcasting.tooltip.spellbook.page_with_name.sealed", new Object[]{new TextComponent(String.valueOf(newIdx)).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(len)).m_130940_(ChatFormatting.WHITE), new TextComponent("").m_130944_(new ChatFormatting[]{stack.m_41791_().f_43022_, ChatFormatting.ITALIC}).m_7220_(stack.m_41786_()), new TranslatableComponent("hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD)}) : new TranslatableComponent("hexcasting.tooltip.spellbook.page_with_name", new Object[]{new TextComponent(String.valueOf(newIdx)).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(len)).m_130940_(ChatFormatting.WHITE), new TextComponent("").m_130944_(new ChatFormatting[]{stack.m_41791_().f_43022_, ChatFormatting.ITALIC}).m_7220_(stack.m_41786_())})) : (sealed ? new TranslatableComponent("hexcasting.tooltip.spellbook.page.sealed", new Object[]{new TextComponent(String.valueOf(newIdx)).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(len)).m_130940_(ChatFormatting.WHITE), new TranslatableComponent("hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD)}) : new TranslatableComponent("hexcasting.tooltip.spellbook.page", new Object[]{new TextComponent(String.valueOf(newIdx)).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(len)).m_130940_(ChatFormatting.WHITE)}));
        sender.m_5661_((Component)component.m_130940_(ChatFormatting.GRAY), true);
    }

    private void abacus(ServerPlayer sender, ItemStack stack) {
        float pitch;
        double delta;
        boolean increase = this.scrollDelta < 0.0;
        double num = NBTHelper.getDouble((ItemStack)stack, (String)"value");
        if (this.hand == InteractionHand.MAIN_HAND) {
            delta = this.isCtrl ? 10.0 : 1.0;
            pitch = this.isCtrl ? 0.7f : 0.9f;
        } else {
            delta = this.isCtrl ? 0.01 : 0.1;
            pitch = this.isCtrl ? 1.3f : 1.0f;
        }
        NBTHelper.putDouble((ItemStack)stack, (String)"value", (double)(num += delta * (double)(increase ? 1 : -1)));
        pitch *= increase ? 1.05f : 0.95f;
        pitch = (float)((double)pitch + (Math.random() - 0.5) * 0.1);
        sender.f_19853_.m_6263_(null, sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), HexSounds.ABACUS, SoundSource.PLAYERS, 0.5f, pitch);
        CompoundTag datumTag = HexItems.ABACUS.readDatumTag(stack);
        if (datumTag != null) {
            Component popup = SpellDatum.displayFromNBT((CompoundTag)datumTag);
            sender.m_5661_((Component)new TranslatableComponent("hexcasting.tooltip.abacus", new Object[]{popup}).m_130940_(ChatFormatting.GREEN), true);
        }
    }
}

