/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.client.gui.GuiSpellcasting;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record MsgNewSpellPatternAck(ControllerInfo info) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("pat_sc");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgNewSpellPatternAck deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        boolean wasSpellCast = buf.readBoolean();
        boolean isStackEmpty = buf.readBoolean();
        ResolvedPatternType resolutionType = (ResolvedPatternType)buf.m_130066_(ResolvedPatternType.class);
        int descsLen = buf.readInt();
        ArrayList<Component> desc = new ArrayList<Component>(descsLen);
        for (int i = 0; i < descsLen; ++i) {
            desc.add(buf.m_130238_());
        }
        return new MsgNewSpellPatternAck(new ControllerInfo(wasSpellCast, isStackEmpty, resolutionType, desc));
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.writeBoolean(this.info.getMakesCastSound());
        buf.writeBoolean(this.info.isStackClear());
        buf.m_130068_((Enum)this.info.getResolutionType());
        buf.writeInt(this.info.getStackDesc().size());
        for (Component desc : this.info.getStackDesc()) {
            buf.m_130083_(desc);
        }
    }

    public static void handle(final MsgNewSpellPatternAck self) {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Screen screen;
                Minecraft mc = Minecraft.m_91087_();
                if (self.info().isStackClear()) {
                    mc.m_91106_().m_120386_(HexSounds.CASTING_AMBIANCE.m_11660_(), null);
                }
                if ((screen = Minecraft.m_91087_().f_91080_) instanceof GuiSpellcasting) {
                    GuiSpellcasting spellGui = (GuiSpellcasting)screen;
                    if (self.info().isStackClear()) {
                        mc.m_91152_(null);
                    } else {
                        spellGui.recvServerUpdate(self.info());
                    }
                }
            }
        });
    }
}

