/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public record MsgCastParticleAck(ParticleSpray spray, FrozenColorizer colorizer) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("cprtcl");
    private static final Random RANDOM = new Random();

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgCastParticleAck deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double velX = buf.readDouble();
        double velY = buf.readDouble();
        double velZ = buf.readDouble();
        double fuzziness = buf.readDouble();
        double spread = buf.readDouble();
        int count = buf.readInt();
        CompoundTag tag = buf.m_130261_();
        FrozenColorizer colorizer = FrozenColorizer.fromNBT(tag);
        return new MsgCastParticleAck(new ParticleSpray(new Vec3(posX, posY, posZ), new Vec3(velX, velY, velZ), fuzziness, spread, count), colorizer);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.writeDouble(this.spray.getPos().f_82479_);
        buf.writeDouble(this.spray.getPos().f_82480_);
        buf.writeDouble(this.spray.getPos().f_82481_);
        buf.writeDouble(this.spray.getVel().f_82479_);
        buf.writeDouble(this.spray.getVel().f_82480_);
        buf.writeDouble(this.spray.getVel().f_82481_);
        buf.writeDouble(this.spray.getFuzziness());
        buf.writeDouble(this.spray.getSpread());
        buf.writeInt(this.spray.getCount());
        buf.m_130079_(this.colorizer.serializeToNBT());
    }

    private static Vec3 randomInCircle(double maxTh) {
        double th = RANDOM.nextDouble(0.0, maxTh + 0.001);
        double z = RANDOM.nextDouble(-1.0, 1.0);
        return new Vec3(Math.sqrt(1.0 - z * z) * Math.cos(th), Math.sqrt(1.0 - z * z) * Math.sin(th), z);
    }

    public static void handle(final MsgCastParticleAck msg) {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < msg.spray().getCount(); ++i) {
                    int color = msg.colorizer().getColor(RANDOM.nextFloat() * 256.0f, Vec3.f_82478_);
                    Vec3 offset = MsgCastParticleAck.randomInCircle(6.2831854820251465).m_82541_().m_82490_((double)RANDOM.nextFloat() * msg.spray().getSpread() / 2.0);
                    Vec3 pos = msg.spray().getPos().m_82549_(offset);
                    double phi = Math.acos(1.0 - RANDOM.nextDouble() * (1.0 - Math.cos(msg.spray().getSpread())));
                    double theta = Math.PI * 2 * RANDOM.nextDouble();
                    Vec3 v = msg.spray().getVel().m_82541_();
                    Vec3 k = v.f_82479_ == 0.0 && v.f_82480_ == 0.0 ? new Vec3(1.0, 0.0, 0.0) : v.m_82537_(new Vec3(0.0, 0.0, 1.0));
                    Vec3 velUnlen = v.m_82490_(Math.cos(phi)).m_82549_(k.m_82490_(Math.sin(phi) * Math.cos(theta))).m_82549_(v.m_82537_(k).m_82490_(Math.sin(phi) * Math.sin(theta)));
                    Vec3 vel = velUnlen.m_82490_(msg.spray().getVel().m_82553_() / 20.0);
                    Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)new ConjureParticleOptions(color, false), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                }
            }
        });
    }
}

