/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.common.blocks.BlockConjuredLight;
import at.petrak.hexcasting.common.blocks.BlockFlammable;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicFloodfiller;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicRecord;
import at.petrak.hexcasting.common.blocks.circles.BlockEmptyImpetus;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockEmptyDirectrix;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockRedstoneDirectrix;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockLookingImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockRightClickImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockStoredPlayerImpetus;
import at.petrak.hexcasting.common.blocks.decoration.BlockAkashicLeaves;
import at.petrak.hexcasting.common.blocks.decoration.BlockAkashicLog;
import at.petrak.hexcasting.common.blocks.decoration.BlockAxis;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexDoor;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexPressurePlate;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexSlab;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexStairs;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexTrapdoor;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexWoodButton;
import at.petrak.hexcasting.common.blocks.decoration.BlockSconce;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class HexBlocks {
    private static final Map<ResourceLocation, Block> BLOCKS = new LinkedHashMap<ResourceLocation, Block>();
    private static final Map<ResourceLocation, Pair<Block, Item.Properties>> BLOCK_ITEMS = new LinkedHashMap<ResourceLocation, Pair<Block, Item.Properties>>();
    public static final Block CONJURED_LIGHT = HexBlocks.blockItem("conjured", new BlockConjuredLight(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76398_).m_60918_(SoundType.f_154654_).m_60953_(state -> 15).m_60993_().m_60922_((xva$0, xva$1, xva$2, xva$3) -> HexBlocks.never(xva$0, xva$1, xva$2, xva$3)).m_60966_().m_60910_().m_60960_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2)).m_60971_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2))), new Item.Properties());
    public static final Block CONJURED_BLOCK = HexBlocks.blockItem("conjured_block", new BlockConjured(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76398_).m_60918_(SoundType.f_154654_).m_60953_(state -> 2).m_60993_().m_60922_((xva$0, xva$1, xva$2, xva$3) -> HexBlocks.never(xva$0, xva$1, xva$2, xva$3)).m_60966_().m_60955_().m_60960_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2)).m_60971_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2))), new Item.Properties());
    public static final BlockSlate SLATE = HexBlocks.blockNoItem("slate", new BlockSlate(HexBlocks.slateish()));
    public static final BlockEmptyImpetus EMPTY_IMPETUS = HexBlocks.blockItem("empty_impetus", new BlockEmptyImpetus(HexBlocks.slateish()));
    public static final BlockRightClickImpetus IMPETUS_RIGHTCLICK = HexBlocks.blockItem("impetus_rightclick", new BlockRightClickImpetus(HexBlocks.slateish().m_60953_(bs -> (Boolean)bs.m_61143_((Property)BlockAbstractImpetus.ENERGIZED) != false ? 15 : 0)));
    public static final BlockLookingImpetus IMPETUS_LOOK = HexBlocks.blockItem("impetus_look", new BlockLookingImpetus(HexBlocks.slateish().m_60953_(bs -> (Boolean)bs.m_61143_((Property)BlockAbstractImpetus.ENERGIZED) != false ? 15 : 0)));
    public static final BlockStoredPlayerImpetus IMPETUS_STOREDPLAYER = HexBlocks.blockItem("impetus_storedplayer", new BlockStoredPlayerImpetus(HexBlocks.slateish().m_60953_(bs -> (Boolean)bs.m_61143_((Property)BlockAbstractImpetus.ENERGIZED) != false ? 15 : 0)));
    public static final BlockEmptyDirectrix EMPTY_DIRECTRIX = HexBlocks.blockItem("empty_directrix", new BlockEmptyDirectrix(HexBlocks.slateish()));
    public static final BlockRedstoneDirectrix DIRECTRIX_REDSTONE = HexBlocks.blockItem("directrix_redstone", new BlockRedstoneDirectrix(HexBlocks.slateish()));
    public static final BlockAkashicRecord AKASHIC_RECORD = HexBlocks.blockItem("akashic_record", new BlockAkashicRecord(HexBlocks.akashicWoodyHard().m_60953_(bs -> 15)));
    public static final BlockAkashicBookshelf AKASHIC_BOOKSHELF = HexBlocks.blockItem("akashic_bookshelf", new BlockAkashicBookshelf(HexBlocks.akashicWoodyHard().m_60953_(bs -> bs.m_61143_(BlockAkashicBookshelf.DATUM_TYPE) == DatumType.EMPTY ? 0 : 4)));
    public static final BlockAkashicFloodfiller AKASHIC_CONNECTOR = HexBlocks.blockItem("akashic_connector", new BlockAkashicFloodfiller(HexBlocks.akashicWoodyHard().m_60953_(bs -> 10)));
    public static final Block SLATE_BLOCK = HexBlocks.blockItem("slate_block", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final SandBlock AMETHYST_DUST_BLOCK = HexBlocks.blockItem("amethyst_dust_block", new SandBlock(-5009677, BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76422_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
    public static final AmethystBlock AMETHYST_TILES = HexBlocks.blockItem("amethyst_tiles", new AmethystBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final Block SCROLL_PAPER = HexBlocks.blockItem("scroll_paper", new BlockFlammable(HexBlocks.papery(MaterialColor.f_76372_), 100, 60));
    public static final Block ANCIENT_SCROLL_PAPER = HexBlocks.blockItem("ancient_scroll_paper", new BlockFlammable(HexBlocks.papery(MaterialColor.f_76373_), 100, 60));
    public static final Block SCROLL_PAPER_LANTERN = HexBlocks.blockItem("scroll_paper_lantern", new BlockFlammable(HexBlocks.papery(MaterialColor.f_76372_).m_60953_($ -> 15), 100, 60));
    public static final Block ANCIENT_SCROLL_PAPER_LANTERN = HexBlocks.blockItem("ancient_scroll_paper_lantern", new BlockFlammable(HexBlocks.papery(MaterialColor.f_76373_).m_60953_($ -> 12), 100, 60));
    public static final BlockSconce SCONCE = HexBlocks.blockItem("amethyst_sconce", new BlockSconce(BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)MaterialColor.f_76422_).m_60918_(SoundType.f_154654_).m_60978_(1.0f).m_60953_($ -> 15)));
    public static final BlockAxis AKASHIC_LOG = HexBlocks.blockItem("akashic_log", new BlockAkashicLog(HexBlocks.akashicWoody()));
    public static final BlockAxis AKASHIC_LOG_STRIPPED = HexBlocks.blockItem("akashic_log_stripped", new BlockAkashicLog(HexBlocks.akashicWoody()));
    public static final Block AKASHIC_WOOD = HexBlocks.blockItem("akashic_wood", new BlockFlammable(HexBlocks.akashicWoody(), 5, 5));
    public static final Block AKASHIC_WOOD_STRIPPED = HexBlocks.blockItem("akashic_wood_stripped", new BlockFlammable(HexBlocks.akashicWoody(), 5, 5));
    public static final Block AKASHIC_PLANKS = HexBlocks.blockItem("akashic_planks", new BlockFlammable(HexBlocks.akashicWoody(), 20, 5));
    public static final Block AKASHIC_PANEL = HexBlocks.blockItem("akashic_panel", new BlockFlammable(HexBlocks.akashicWoody(), 20, 5));
    public static final Block AKASHIC_TILE = HexBlocks.blockItem("akashic_tile", new BlockFlammable(HexBlocks.akashicWoody(), 20, 5));
    public static final DoorBlock AKASHIC_DOOR = HexBlocks.blockItem("akashic_door", new BlockHexDoor(HexBlocks.akashicWoody().m_60955_()));
    public static final TrapDoorBlock AKASHIC_TRAPDOOR = HexBlocks.blockItem("akashic_trapdoor", new BlockHexTrapdoor(HexBlocks.akashicWoody().m_60955_()));
    public static final StairBlock AKASHIC_STAIRS = HexBlocks.blockItem("akashic_stairs", new BlockHexStairs(AKASHIC_PLANKS.m_49966_(), HexBlocks.akashicWoody().m_60955_()));
    public static final SlabBlock AKASHIC_SLAB = HexBlocks.blockItem("akashic_slab", new BlockHexSlab(HexBlocks.akashicWoody().m_60955_()));
    public static final WoodButtonBlock AKASHIC_BUTTON = HexBlocks.blockItem("akashic_button", new BlockHexWoodButton(HexBlocks.akashicWoody().m_60955_()));
    public static final PressurePlateBlock AKASHIC_PRESSURE_PLATE = HexBlocks.blockItem("akashic_pressure_plate", new BlockHexPressurePlate(PressurePlateBlock.Sensitivity.EVERYTHING, HexBlocks.akashicWoody().m_60955_()));
    public static final BlockAkashicLeaves AKASHIC_LEAVES1 = HexBlocks.blockItem("akashic_leaves1", new BlockAkashicLeaves(HexBlocks.leaves(MaterialColor.f_76422_)));
    public static final BlockAkashicLeaves AKASHIC_LEAVES2 = HexBlocks.blockItem("akashic_leaves2", new BlockAkashicLeaves(HexBlocks.leaves(MaterialColor.f_76361_)));
    public static final BlockAkashicLeaves AKASHIC_LEAVES3 = HexBlocks.blockItem("akashic_leaves3", new BlockAkashicLeaves(HexBlocks.leaves(MaterialColor.f_76416_)));

    public static void registerBlocks(BiConsumer<Block, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Block> e : BLOCKS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static void registerBlockItems(BiConsumer<Item, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Pair<Block, Item.Properties>> e : BLOCK_ITEMS.entrySet()) {
            r.accept((Item)new BlockItem((Block)e.getValue().getFirst(), (Item.Properties)e.getValue().getSecond()), e.getKey());
        }
    }

    private static BlockBehaviour.Properties slateish() {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_164534_).m_60918_(SoundType.f_154679_).m_60913_(4.0f, 4.0f);
    }

    private static BlockBehaviour.Properties papery(MaterialColor color) {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)color).m_60918_(SoundType.f_56740_).m_60966_();
    }

    private static BlockBehaviour.Properties akashicWoodyHard() {
        return HexBlocks.woodyHard(MaterialColor.f_76422_);
    }

    private static BlockBehaviour.Properties woodyHard(MaterialColor color) {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60918_(SoundType.f_56736_).m_60913_(3.0f, 4.0f);
    }

    private static BlockBehaviour.Properties akashicWoody() {
        return HexBlocks.woody(MaterialColor.f_76422_);
    }

    private static BlockBehaviour.Properties woody(MaterialColor color) {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60918_(SoundType.f_56736_).m_60978_(2.0f);
    }

    private static BlockBehaviour.Properties leaves(MaterialColor color) {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76274_, (MaterialColor)color).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((bs, level, pos, type) -> type == EntityType.f_20505_ || type == EntityType.f_20508_).m_60960_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2)).m_60971_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2));
    }

    private static boolean never(Object ... args) {
        return false;
    }

    private static <T extends Block> T blockNoItem(String name, T block) {
        Block old = BLOCKS.put(HexAPI.modLoc(name), block);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return block;
    }

    private static <T extends Block> T blockItem(String name, T block) {
        return HexBlocks.blockItem(name, block, HexItems.props());
    }

    private static <T extends Block> T blockItem(String name, T block, Item.Properties props) {
        HexBlocks.blockNoItem(name, block);
        Pair<Block, Item.Properties> old = BLOCK_ITEMS.put(HexAPI.modLoc(name), (Pair<Block, Item.Properties>)new Pair(block, (Object)props));
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return block;
    }
}

