/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemSpellbook
extends Item
implements DataHolderItem {
    public static String TAG_SELECTED_PAGE = "page_idx";
    public static String TAG_PAGES = "pages";
    public static String TAG_PAGE_NAMES = "page_names";
    public static String TAG_SEALED = "sealed_pages";

    public ItemSpellbook(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        boolean sealed = ItemSpellbook.IsSealed(stack);
        boolean empty = false;
        if (NBTHelper.hasNumber((ItemStack)stack, (String)TAG_SELECTED_PAGE)) {
            int pageIdx = NBTHelper.getInt((ItemStack)stack, (String)TAG_SELECTED_PAGE);
            int highest = ItemSpellbook.HighestPage(stack);
            if (highest != 0) {
                if (sealed) {
                    tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.spellbook.page.sealed", new Object[]{new TextComponent(String.valueOf(pageIdx)).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(highest)).m_130940_(ChatFormatting.WHITE), new TranslatableComponent("hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.spellbook.page", new Object[]{new TextComponent(String.valueOf(pageIdx)).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(highest)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
                }
            } else {
                empty = true;
            }
        } else {
            empty = true;
        }
        if (empty) {
            boolean overridden = NBTHelper.hasString((ItemStack)stack, (String)"VisualOverride");
            if (sealed) {
                if (overridden) {
                    tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD));
                } else {
                    tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.spellbook.empty.sealed", new Object[]{new TranslatableComponent("hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
                }
            } else if (!overridden) {
                tooltip.add((Component)new TranslatableComponent("hexcasting.tooltip.spellbook.empty").m_130940_(ChatFormatting.GRAY));
            }
        }
        DataHolderItem.appendHoverText(this, stack, tooltip, isAdvanced);
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }

    public void m_6883_(ItemStack stack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        int index = ItemSpellbook.GetPage(stack, 0);
        NBTHelper.putInt((ItemStack)stack, (String)TAG_SELECTED_PAGE, (int)index);
        int shiftedIdx = Math.max(1, index);
        String nameKey = String.valueOf(shiftedIdx);
        CompoundTag names = NBTHelper.getOrCreateCompound((ItemStack)stack, (String)TAG_PAGE_NAMES);
        if (stack.m_41788_()) {
            names.m_128359_(nameKey, Component.Serializer.m_130703_((Component)stack.m_41786_()));
        } else {
            names.m_128473_(nameKey);
        }
    }

    public static boolean ArePagesEmpty(ItemStack stack) {
        CompoundTag tag = NBTHelper.getCompound((ItemStack)stack, (String)TAG_PAGES);
        return tag == null || tag.m_128456_();
    }

    @Override
    @Nullable
    public CompoundTag readDatumTag(ItemStack stack) {
        int idx = ItemSpellbook.GetPage(stack, 1);
        String key = String.valueOf(idx);
        CompoundTag tag = NBTHelper.getCompound((ItemStack)stack, (String)TAG_PAGES);
        if (tag != null && tag.m_128425_(key, 10)) {
            return tag.m_128469_(key);
        }
        return null;
    }

    @Override
    @Nullable
    public SpellDatum<?> emptyDatum(ItemStack stack) {
        return SpellDatum.make((Object)Widget.NULL);
    }

    @Override
    public boolean canWrite(ItemStack stack, SpellDatum<?> datum) {
        return datum == null || !ItemSpellbook.IsSealed(stack);
    }

    @Override
    public void writeDatum(ItemStack stack, SpellDatum<?> datum) {
        if (datum != null && ItemSpellbook.IsSealed(stack)) {
            return;
        }
        int idx = ItemSpellbook.GetPage(stack, 1);
        String key = String.valueOf(idx);
        CompoundTag pages = NBTHelper.getCompound((ItemStack)stack, (String)TAG_PAGES);
        if (pages != null) {
            if (datum == null) {
                pages.m_128473_(key);
                NBTHelper.remove((CompoundTag)NBTHelper.getCompound((ItemStack)stack, (String)TAG_SEALED), (String)key);
            } else {
                pages.m_128365_(key, (Tag)datum.serializeToNBT());
            }
            if (pages.m_128456_()) {
                NBTHelper.remove((ItemStack)stack, (String)TAG_PAGES);
            }
        } else if (datum != null) {
            NBTHelper.getOrCreateCompound((ItemStack)stack, (String)TAG_PAGES).m_128365_(key, (Tag)datum.serializeToNBT());
        } else {
            NBTHelper.remove((CompoundTag)NBTHelper.getCompound((ItemStack)stack, (String)TAG_SEALED), (String)key);
        }
    }

    public static int GetPage(ItemStack stack, int ifEmpty) {
        if (ItemSpellbook.ArePagesEmpty(stack)) {
            return ifEmpty;
        }
        if (NBTHelper.hasNumber((ItemStack)stack, (String)TAG_SELECTED_PAGE)) {
            int index = NBTHelper.getInt((ItemStack)stack, (String)TAG_SELECTED_PAGE);
            if (index == 0) {
                index = 1;
            }
            return index;
        }
        return 1;
    }

    public static void SetSealed(ItemStack stack, boolean sealed) {
        int index = ItemSpellbook.GetPage(stack, 1);
        String nameKey = String.valueOf(index);
        CompoundTag names = NBTHelper.getOrCreateCompound((ItemStack)stack, (String)TAG_SEALED);
        if (!sealed) {
            names.m_128473_(nameKey);
        } else {
            names.m_128379_(nameKey, true);
        }
        if (names.m_128456_()) {
            NBTHelper.remove((ItemStack)stack, (String)TAG_SEALED);
        } else {
            NBTHelper.putCompound((ItemStack)stack, (String)TAG_SEALED, (CompoundTag)names);
        }
    }

    public static boolean IsSealed(ItemStack stack) {
        int index = ItemSpellbook.GetPage(stack, 1);
        String nameKey = String.valueOf(index);
        CompoundTag names = NBTHelper.getCompound((ItemStack)stack, (String)TAG_SEALED);
        return NBTHelper.getBoolean((CompoundTag)names, (String)nameKey);
    }

    public static int HighestPage(ItemStack stack) {
        CompoundTag tag = NBTHelper.getCompound((ItemStack)stack, (String)TAG_PAGES);
        if (tag == null) {
            return 0;
        }
        return tag.m_128431_().stream().flatMap(s -> {
            try {
                return Stream.of(Integer.valueOf(Integer.parseInt(s)));
            }
            catch (NumberFormatException e) {
                return Stream.empty();
            }
        }).max(Integer::compare).orElse(0);
    }

    public static int RotatePageIdx(ItemStack stack, boolean increase) {
        int idx = ItemSpellbook.GetPage(stack, 0);
        if (idx != 0) {
            idx += increase ? 1 : -1;
            idx = Math.max(1, idx);
        }
        NBTHelper.putInt((ItemStack)stack, (String)TAG_SELECTED_PAGE, (int)idx);
        CompoundTag names = NBTHelper.getCompound((ItemStack)stack, (String)TAG_PAGE_NAMES);
        int shiftedIdx = Math.max(1, idx);
        String nameKey = String.valueOf(shiftedIdx);
        String name = NBTHelper.getString((CompoundTag)names, (String)nameKey);
        if (name != null) {
            stack.m_41714_((Component)Component.Serializer.m_130701_((String)name));
        } else {
            stack.m_41787_();
        }
        return idx;
    }
}

