/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.misc.TriPredicate;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicRecord;
import at.petrak.hexcasting.common.lib.HexBlocks;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockAkashicFloodfiller
extends Block {
    public BlockAkashicFloodfiller(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @Nullable
    public BlockPos getRecordPosition(BlockPos here, BlockState state, Level world) {
        return BlockAkashicFloodfiller.floodFillFor(here, world, (pos, bs, level) -> bs.m_60713_((Block)HexBlocks.AKASHIC_RECORD));
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        BlockPos recordPos = this.getRecordPosition(pPos, pState, pLevel);
        if (recordPos != null && (blockEntity = pLevel.m_7702_(recordPos)) instanceof BlockEntityAkashicRecord) {
            BlockEntityAkashicRecord akashic = (BlockEntityAkashicRecord)blockEntity;
            akashic.removeFloodfillerAt(pPos);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public boolean canBeFloodedThrough(BlockPos pos, BlockState state, Level world) {
        return true;
    }

    @Nullable
    public static BlockPos floodFillFor(BlockPos start, Level world, TriPredicate<BlockPos, BlockState, Level> isValid, TriPredicate<BlockPos, BlockState, Level> isTarget) {
        HashSet<BlockPos> seenBlocks = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.add(start);
        while (!todo.isEmpty()) {
            BlockPos here = (BlockPos)todo.remove();
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = here.m_142300_(dir);
                if (!seenBlocks.add(neighbor)) continue;
                BlockState bs = world.m_8055_(neighbor);
                if (isTarget.test(neighbor, bs, world)) {
                    return neighbor;
                }
                if (!isValid.test(neighbor, bs, world)) continue;
                todo.add(neighbor);
            }
        }
        return null;
    }

    @Nullable
    public static BlockPos floodFillFor(BlockPos start, Level world, TriPredicate<BlockPos, BlockState, Level> isTarget) {
        return BlockAkashicFloodfiller.floodFillFor(start, world, BlockAkashicFloodfiller::canItBeFloodedThrough, isTarget);
    }

    public static boolean canItBeFloodedThrough(BlockPos pos, BlockState state, Level world) {
        Block block = state.m_60734_();
        if (!(block instanceof BlockAkashicFloodfiller)) {
            return false;
        }
        BlockAkashicFloodfiller flooder = (BlockAkashicFloodfiller)block;
        return flooder.canBeFloodedThrough(pos, state, world);
    }
}

