/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.item;

import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public interface DataHolderItem {
    public static final String TAG_OVERRIDE_VISUALLY = "VisualOverride";

    @Nullable
    public CompoundTag readDatumTag(ItemStack var1);

    @Nullable
    default public SpellDatum<?> readDatum(ItemStack stack, ServerLevel world) {
        CompoundTag tag = this.readDatumTag(stack);
        if (tag != null) {
            return SpellDatum.fromNBT((CompoundTag)tag, (ServerLevel)world);
        }
        return null;
    }

    @Nullable
    default public SpellDatum<?> emptyDatum(ItemStack stack) {
        return null;
    }

    public boolean canWrite(ItemStack var1, @Nullable SpellDatum<?> var2);

    public void writeDatum(ItemStack var1, @Nullable SpellDatum<?> var2);

    public static void appendHoverText(DataHolderItem self, ItemStack pStack, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag datumTag = self.readDatumTag(pStack);
        if (datumTag != null) {
            Component component = SpellDatum.displayFromNBT((CompoundTag)datumTag);
            pTooltipComponents.add((Component)new TranslatableComponent("hexcasting.spelldata.onitem", new Object[]{component}));
            if (pIsAdvanced.m_7050_()) {
                pTooltipComponents.add((Component)new TextComponent("").m_7220_(NbtUtils.m_178061_((Tag)datumTag)));
            }
        } else if (NBTHelper.hasString((ItemStack)pStack, (String)TAG_OVERRIDE_VISUALLY)) {
            pTooltipComponents.add((Component)new TranslatableComponent("hexcasting.spelldata.onitem", new Object[]{new TranslatableComponent("hexcasting.spelldata.anything").m_130940_(ChatFormatting.LIGHT_PURPLE)}));
        }
    }
}

