/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.client;

import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScryingLensOverlayRegistry {
    private static final ConcurrentMap<ResourceLocation, OverlayBuilder> ID_LOOKUP = new ConcurrentHashMap<ResourceLocation, OverlayBuilder>();
    private static final List<Pair<OverlayPredicate, OverlayBuilder>> PREDICATE_LOOKUP = new Vector<Pair<OverlayPredicate, OverlayBuilder>>();
    private static final Map<LocalPlayer, Pair<BlockPos, Integer>> comparatorData = new WeakHashMap<LocalPlayer, Pair<BlockPos, Integer>>();

    public static void receiveComparatorValue(BlockPos pos, int value) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (pos == null || value == -1) {
                comparatorData.remove(player);
            } else {
                comparatorData.put(player, (Pair<BlockPos, Integer>)new Pair((Object)pos, (Object)value));
            }
        }
    }

    public static int getComparatorValue(boolean onlyRealComparators) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        HitResult result = mc.f_91077_;
        if (player == null || level == null || result == null || result.m_6662_() != HitResult.Type.BLOCK) {
            return -1;
        }
        Pair<BlockPos, Integer> comparatorValue = comparatorData.get(player);
        if (comparatorValue == null) {
            return -1;
        }
        BlockPos pos = ((BlockHitResult)result).m_82425_();
        if (!pos.equals(comparatorValue.getFirst())) {
            return -1;
        }
        BlockState state = mc.f_91073_.m_8055_(pos);
        if (onlyRealComparators && !state.m_60713_(Blocks.f_50328_) || !onlyRealComparators && !state.m_60807_()) {
            return -1;
        }
        return (Integer)comparatorValue.getSecond();
    }

    public static void addDisplayer(Block block, OverlayBuilder displayer) {
        ScryingLensOverlayRegistry.addDisplayer(IXplatAbstractions.INSTANCE.getID(block), displayer);
    }

    public static void addDisplayer(ResourceLocation blockID, OverlayBuilder displayer) {
        if (ID_LOOKUP.containsKey(blockID)) {
            throw new IllegalArgumentException("Already have a displayer for " + blockID);
        }
        ID_LOOKUP.put(blockID, displayer);
    }

    public static void addPredicateDisplayer(OverlayPredicate predicate, OverlayBuilder displayer) {
        PREDICATE_LOOKUP.add((Pair<OverlayPredicate, OverlayBuilder>)new Pair((Object)predicate, (Object)displayer));
    }

    @NotNull
    public static List<Pair<ItemStack, Component>> getLines(BlockState state, BlockPos pos, LocalPlayer observer, ClientLevel world, Direction hitFace, @Nullable InteractionHand lensHand) {
        ArrayList lines = Lists.newArrayList();
        OverlayBuilder idLookedup = (OverlayBuilder)ID_LOOKUP.get(IXplatAbstractions.INSTANCE.getID(state.m_60734_()));
        if (idLookedup != null) {
            idLookedup.addLines(lines, state, pos, observer, world, hitFace, lensHand);
        }
        for (Pair<OverlayPredicate, OverlayBuilder> pair : PREDICATE_LOOKUP) {
            if (!((OverlayPredicate)pair.getFirst()).test(state, pos, observer, world, hitFace, lensHand)) continue;
            ((OverlayBuilder)pair.getSecond()).addLines(lines, state, pos, observer, world, hitFace, lensHand);
        }
        return lines;
    }

    @FunctionalInterface
    public static interface OverlayBuilder {
        public void addLines(List<Pair<ItemStack, Component>> var1, BlockState var2, BlockPos var3, LocalPlayer var4, ClientLevel var5, Direction var6, @Nullable InteractionHand var7);
    }

    @FunctionalInterface
    public static interface OverlayPredicate {
        public boolean test(BlockState var1, BlockPos var2, LocalPlayer var3, ClientLevel var4, Direction var5, @Nullable InteractionHand var6);
    }
}

