/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SpendManaTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("hexcasting", "spend_mana");
    private static final String TAG_MANA_SPENT = "mana_spent";
    private static final String TAG_MANA_WASTED = "mana_wasted";

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext pContext) {
        return new Instance(predicate, MinMaxBounds.Ints.m_55373_((JsonElement)json.get(TAG_MANA_SPENT)), MinMaxBounds.Ints.m_55373_((JsonElement)json.get(TAG_MANA_WASTED)));
    }

    public void trigger(ServerPlayer player, int manaSpent, int manaWasted) {
        super.m_66234_(player, inst -> inst.test(manaSpent, manaWasted));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final MinMaxBounds.Ints manaSpent;
        protected final MinMaxBounds.Ints manaWasted;

        public Instance(EntityPredicate.Composite predicate, MinMaxBounds.Ints manaSpent, MinMaxBounds.Ints manaWasted) {
            super(ID, predicate);
            this.manaSpent = manaSpent;
            this.manaWasted = manaWasted;
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext ctx) {
            JsonObject json = super.m_7683_(ctx);
            if (!this.manaSpent.m_55327_()) {
                json.add(SpendManaTrigger.TAG_MANA_SPENT, this.manaSpent.m_55328_());
            }
            if (!this.manaWasted.m_55327_()) {
                json.add(SpendManaTrigger.TAG_MANA_WASTED, this.manaWasted.m_55328_());
            }
            return json;
        }

        private boolean test(int manaSpentIn, int manaWastedIn) {
            return this.manaSpent.m_55390_(manaSpentIn) && this.manaWasted.m_55390_(manaWastedIn);
        }
    }
}

