/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.utils;

import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.interop.utils.PatternEntry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_241;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5944;
import net.minecraft.class_757;

public final class PatternDrawingUtil {
    public static void drawPattern(class_4587 poseStack, int x, int y, List<PatternEntry> patterns, List<class_241> dots, boolean strokeOrder, long animTicks, int outer, int innerLight, int innerDark, int dotColor) {
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, 1.0);
        class_1159 mat = poseStack.method_23760().method_23761();
        class_5944 prevShader = RenderSystem.getShader();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        for (PatternEntry pat : patterns) {
            RenderLib.drawLineSeq(mat, pat.zappyPoints(), 5.0f, 0.0f, outer, outer, null);
            RenderLib.drawLineSeq(mat, pat.zappyPoints(), 2.0f, 0.0f, strokeOrder ? innerDark : innerLight, innerLight, strokeOrder ? Float.valueOf((float)animTicks / 20.0f) : null);
            if (!strokeOrder) continue;
            RenderLib.drawSpot(mat, pat.zappyPoints().get(0), 2.5f, 1.0f, 0.1f, 0.15f, 0.6f);
        }
        float dotR = (float)class_5253.class_5254.method_27765((int)dotColor) / 255.0f;
        float dotG = (float)class_5253.class_5254.method_27766((int)dotColor) / 255.0f;
        float dotB = (float)class_5253.class_5254.method_27767((int)dotColor) / 255.0f;
        float dotA = (float)class_5253.class_5254.method_27762((int)dotColor) / 255.0f;
        for (class_241 dot : dots) {
            RenderLib.drawSpot(mat, dot, 1.5f, dotR, dotG, dotB, dotA);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(() -> prevShader);
        poseStack.method_22909();
    }

    public static PatternRenderingData loadPatterns(List<Pair<HexPattern, HexCoord>> patterns) {
        ArrayList<PatternEntry> patternEntries = new ArrayList<PatternEntry>(patterns.size());
        boolean fakeScale = true;
        ArrayList<class_241> seenFakePoints = new ArrayList<class_241>();
        HashSet<HexCoord> seenCoords = new HashSet<HexCoord>();
        for (Pair<HexPattern, HexCoord> pair : patterns) {
            HexPattern pattern = (HexPattern)pair.getFirst();
            HexCoord origin = (HexCoord)pair.getSecond();
            for (HexCoord pos : pattern.positions(origin)) {
                class_241 px = HexUtils.coordToPx(pos, (float)fakeScale, class_241.field_1340);
                seenFakePoints.add(px);
            }
            patternEntries.add(new PatternEntry(pattern, origin, new ArrayList<class_241>()));
            seenCoords.addAll(pattern.positions(origin));
        }
        class_241 fakeCom = HexUtils.findCenter(seenFakePoints);
        float maxDx = -1.0f;
        float maxDy = -1.0f;
        for (class_241 dot : seenFakePoints) {
            float dy;
            float dx = class_3532.method_15379((float)(dot.field_1343 - fakeCom.field_1343));
            if (dx > maxDx) {
                maxDx = dx;
            }
            if (!((dy = class_3532.method_15379((float)(dot.field_1342 - fakeCom.field_1342))) > maxDy)) continue;
            maxDy = dy;
        }
        float hexSize = Math.min(12.0f, Math.min(48.0f / maxDx, 28.0f / maxDy));
        ArrayList<class_241> seenRealPoints = new ArrayList<class_241>();
        for (PatternEntry pat : patternEntries) {
            for (HexCoord pos : pat.pattern().positions(pat.origin())) {
                class_241 px = HexUtils.coordToPx(pos, hexSize, class_241.field_1340);
                seenRealPoints.add(px);
            }
        }
        class_241 realCom = HexUtils.findCenter(seenRealPoints);
        for (PatternEntry pat : patternEntries) {
            class_241 localOrigin = HexUtils.coordToPx(pat.origin(), hexSize, realCom.method_35588());
            List<class_241> points = pat.pattern().toLines(hexSize, localOrigin);
            pat.zappyPoints().addAll(RenderLib.makeZappy(points, 10.0f, 0.8f, 0.0f, 0.0f));
        }
        List<class_241> pathfinderDots = seenCoords.stream().map(coord -> HexUtils.coordToPx(coord, hexSize, realCom.method_35588())).toList();
        return new PatternRenderingData(patternEntries, pathfinderDots, hexSize);
    }

    public record PatternRenderingData(List<PatternEntry> patterns, List<class_241> pathfinderDots, float hexSize) {
    }
}

