/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.fabric.cc.HexCardinalComponents;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public abstract class CCManaHolder
extends ItemComponent
implements ManaHolder {
    public CCManaHolder(class_1799 stack) {
        super(stack, HexCardinalComponents.MANA_HOLDER);
    }

    public static class Static
    extends CCManaHolder {
        private final Supplier<Integer> baseWorth;
        private final int consumptionPriority;

        public Static(Supplier<Integer> baseWorth, int consumptionPriority, class_1799 stack) {
            super(stack);
            this.baseWorth = baseWorth;
            this.consumptionPriority = consumptionPriority;
        }

        @Override
        public int getMana() {
            return this.baseWorth.get() * this.stack.method_7947();
        }

        @Override
        public int getMaxMana() {
            return this.getMana();
        }

        @Override
        public void setMana(int mana) {
        }

        @Override
        public boolean canRecharge() {
            return false;
        }

        @Override
        public boolean canProvide() {
            return true;
        }

        @Override
        public int getConsumptionPriority() {
            return this.consumptionPriority;
        }

        @Override
        public boolean canConstructBattery() {
            return true;
        }

        @Override
        public int withdrawMana(int cost, boolean simulate) {
            int worth = this.baseWorth.get();
            if (cost < 0) {
                cost = worth * this.stack.method_7947();
            }
            double itemsRequired = (double)cost / (double)worth;
            int itemsUsed = Math.min((int)Math.ceil(itemsRequired), this.stack.method_7947());
            if (!simulate) {
                this.stack.method_7934(itemsUsed);
            }
            return itemsUsed * worth;
        }
    }

    public static class ItemBased
    extends CCManaHolder {
        private final ManaHolderItem manaHolder;

        public ItemBased(class_1799 stack) {
            super(stack);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof ManaHolderItem)) {
                throw new IllegalStateException("item is not a mana holder: " + stack);
            }
            ManaHolderItem mana = (ManaHolderItem)class_17922;
            this.manaHolder = mana;
        }

        @Override
        public int getMana() {
            return this.manaHolder.getMana(this.stack);
        }

        @Override
        public int getMaxMana() {
            return this.manaHolder.getMaxMana(this.stack);
        }

        @Override
        public void setMana(int mana) {
            this.manaHolder.setMana(this.stack, mana);
        }

        @Override
        public boolean canRecharge() {
            return this.manaHolder.canRecharge(this.stack);
        }

        @Override
        public boolean canProvide() {
            return this.manaHolder.manaProvider(this.stack);
        }

        @Override
        public int getConsumptionPriority() {
            return 40;
        }

        @Override
        public boolean canConstructBattery() {
            return false;
        }
    }
}

