/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.fabric.cc.HexCardinalComponents;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public abstract class CCDataHolder
extends ItemComponent
implements DataHolder {
    public CCDataHolder(class_1799 stack) {
        super(stack, HexCardinalComponents.DATA_HOLDER);
    }

    public static class Static
    extends CCDataHolder {
        private final Function<class_1799, SpellDatum<?>> provider;

        public Static(class_1799 stack, Function<class_1799, SpellDatum<?>> provider) {
            super(stack);
            this.provider = provider;
        }

        @Override
        @Nullable
        public class_2487 readRawDatum() {
            SpellDatum<?> datum = this.provider.apply(this.stack);
            return datum == null ? null : datum.serializeToNBT();
        }

        @Override
        public boolean writeDatum(@Nullable SpellDatum<?> datum, boolean simulate) {
            return false;
        }
    }

    public static class ItemBased
    extends CCDataHolder {
        private final DataHolderItem dataHolder;

        public ItemBased(class_1799 stack) {
            super(stack);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof DataHolderItem)) {
                throw new IllegalStateException("item is not a data holder: " + stack);
            }
            DataHolderItem data = (DataHolderItem)class_17922;
            this.dataHolder = data;
        }

        @Override
        @Nullable
        public class_2487 readRawDatum() {
            return this.dataHolder.readDatumTag(this.stack);
        }

        @Override
        public boolean writeDatum(@Nullable SpellDatum<?> datum, boolean simulate) {
            boolean canWrite = this.dataHolder.canWrite(this.stack, datum);
            if (!canWrite) {
                return false;
            }
            if (!simulate) {
                this.dataHolder.writeDatum(this.stack, datum);
            }
            return true;
        }
    }
}

