/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.fabric;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.class_2960;

public class FabricHexConfig {
    private static final Common COMMON = new Common();
    private static final Client CLIENT = new Client();
    private static final Server SERVER = new Server();

    private static void writeDefaultConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)config, (OutputStream)s2, (ValueSerializer)serializer);
        }
        catch (FileAlreadyExistsException s2) {
        }
        catch (IOException e) {
            HexAPI.LOGGER.error("Error writing default config", (Throwable)e);
        }
    }

    private static void setupConfig(ConfigTree config, Path p, JanksonValueSerializer serializer) {
        FabricHexConfig.writeDefaultConfig(config, p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            HexAPI.LOGGER.error("Error loading config from {}", (Object)p, (Object)e);
        }
    }

    public static void setup() {
        try {
            Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            HexAPI.LOGGER.warn("Failed to make config dir", (Throwable)e);
        }
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        ConfigTree common = COMMON.configure(ConfigTree.builder());
        FabricHexConfig.setupConfig(common, Paths.get("config", "hexcasting-common.json5"), serializer);
        HexConfig.setCommon(COMMON);
        if (IXplatAbstractions.INSTANCE.isPhysicalClient()) {
            ConfigTree client = CLIENT.configure(ConfigTree.builder());
            FabricHexConfig.setupConfig(client, Paths.get("config", "hexcasting-client.json5"), serializer);
            HexConfig.setClient(CLIENT);
        }
        ConfigTree server = SERVER.configure(ConfigTree.builder());
        FabricHexConfig.setupConfig(server, Paths.get("config", "hexcasting-server.json5"), serializer);
        HexConfig.setServer(SERVER);
    }

    private static final class Common
    implements HexConfig.CommonConfigAccess {
        private final PropertyMirror<Integer> dustManaAmount = PropertyMirror.create((ConfigType)ConfigTypes.NATURAL);
        private final PropertyMirror<Integer> shardManaAmount = PropertyMirror.create((ConfigType)ConfigTypes.NATURAL);
        private final PropertyMirror<Integer> chargedCrystalManaAmount = PropertyMirror.create((ConfigType)ConfigTypes.NATURAL);
        private final PropertyMirror<Double> manaToHealthRate = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE.withMinimum((Object)0.0));

        private Common() {
        }

        public ConfigTree configure(ConfigTreeBuilder bob) {
            bob.fork("Mana Amounts").beginValue("dustManaAmount", (ConfigType)ConfigTypes.NATURAL, (Object)10000).withComment("How much mana a single Amethyst Dust item is worth").finishValue(arg_0 -> this.dustManaAmount.mirror(arg_0)).beginValue("shardManaAmount", (ConfigType)ConfigTypes.NATURAL, (Object)50000).withComment("How much mana a single Amethyst Shard item is worth").finishValue(arg_0 -> this.shardManaAmount.mirror(arg_0)).beginValue("chargedCrystalManaAmount", (ConfigType)ConfigTypes.NATURAL, (Object)100000).withComment("How much mana a single Charged Amethyst Crystal item is worth").finishValue(arg_0 -> this.chargedCrystalManaAmount.mirror(arg_0)).beginValue("manaToHealthRate", (ConfigType)ConfigTypes.DOUBLE, (Object)10000.0).withComment("How many points of mana a half-heart is worth when casting from HP").finishValue(arg_0 -> this.manaToHealthRate.mirror(arg_0)).finishBranch();
            return bob.build();
        }

        @Override
        public int dustManaAmount() {
            return (Integer)this.dustManaAmount.getValue();
        }

        @Override
        public int shardManaAmount() {
            return (Integer)this.shardManaAmount.getValue();
        }

        @Override
        public int chargedCrystalManaAmount() {
            return (Integer)this.chargedCrystalManaAmount.getValue();
        }

        @Override
        public double manaToHealthRate() {
            return (Double)this.manaToHealthRate.getValue();
        }
    }

    private static final class Client
    implements HexConfig.ClientConfigAccess {
        private final PropertyMirror<Double> patternPointSpeedMultiplier = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE.withMinimum((Object)0.0));
        private final PropertyMirror<Boolean> ctrlTogglesOffStrokeOrder = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);

        private Client() {
        }

        public ConfigTree configure(ConfigTreeBuilder bob) {
            bob.beginValue("patternPointSpeedMultiplier", (ConfigType)ConfigTypes.DOUBLE, (Object)1.0).withComment("How fast the point showing you the stroke order on patterns moves").finishValue(arg_0 -> this.patternPointSpeedMultiplier.mirror(arg_0)).beginValue("ctrlTogglesOffStrokeOrder", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Whether the ctrl key will instead turn *off* the color gradient on patterns").finishValue(arg_0 -> this.ctrlTogglesOffStrokeOrder.mirror(arg_0));
            return bob.build();
        }

        @Override
        public double patternPointSpeedMultiplier() {
            return (Double)this.patternPointSpeedMultiplier.getValue();
        }

        @Override
        public boolean ctrlTogglesOffStrokeOrder() {
            return (Boolean)this.ctrlTogglesOffStrokeOrder.getValue();
        }
    }

    private static final class Server
    implements HexConfig.ServerConfigAccess {
        private final PropertyMirror<Integer> opBreakHarvestLevel = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER.withValidRange((Object)0, (Object)4, (Object)1));
        private final PropertyMirror<Integer> maxRecurseDepth = PropertyMirror.create((ConfigType)ConfigTypes.NATURAL);
        private final PropertyMirror<Integer> maxSpellCircleLength = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER.withMinimum((Object)4));
        private final PropertyMirror<List<String>> actionDenyList = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
        private final PropertyMirror<List<String>> circleActionDenyList = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
        private final PropertyMirror<Boolean> villagersOffendedByMindMurder = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);

        private Server() {
        }

        public ConfigTree configure(ConfigTreeBuilder bob) {
            bob.fork("Spells").beginValue("maxRecurseDepth", (ConfigType)ConfigTypes.NATURAL, (Object)64).withComment("How many times a spell can recursively cast other spells").finishValue(arg_0 -> this.maxRecurseDepth.mirror(arg_0)).beginValue("opBreakHarvestLevel", (ConfigType)ConfigTypes.NATURAL, (Object)3).withComment("The harvest level of the Break Block spell.\n0 = wood, 1 = stone, 2 = iron, 3 = diamond, 4 = netherite.").finishValue(arg_0 -> this.opBreakHarvestLevel.mirror(arg_0)).finishBranch().fork("Spell Circles").beginValue("maxSpellCircleLength", (ConfigType)ConfigTypes.NATURAL, (Object)1024).withComment("The maximum number of slates in a spell circle").finishValue(arg_0 -> this.maxSpellCircleLength.mirror(arg_0)).beginValue("circleActionDenyList", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), List.of()).withComment("Resource locations of disallowed actions within circles. Trying to cast one of these in a circle will result in a mishap.").finishValue(arg_0 -> this.circleActionDenyList.mirror(arg_0)).finishBranch().beginValue("actionDenyList", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), List.of()).withComment("Resource locations of disallowed actions. Trying to cast one of these will result in a mishap.").finishValue(arg_0 -> this.actionDenyList.mirror(arg_0)).beginValue("villagersOffendedByMindMurder", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Should villagers take offense when you flay the mind of their fellow villagers?").finishValue(arg_0 -> this.villagersOffendedByMindMurder.mirror(arg_0));
            return bob.build();
        }

        @Override
        public int opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort() {
            return (Integer)this.opBreakHarvestLevel.getValue();
        }

        @Override
        public int maxRecurseDepth() {
            return (Integer)this.maxRecurseDepth.getValue();
        }

        @Override
        public int maxSpellCircleLength() {
            return (Integer)this.maxSpellCircleLength.getValue();
        }

        @Override
        public boolean isActionAllowed(class_2960 actionID) {
            return !((List)this.actionDenyList.getValue()).contains(actionID.toString());
        }

        @Override
        public boolean isActionAllowedInCircles(class_2960 actionID) {
            return !((List)this.circleActionDenyList.getValue()).contains(actionID.toString());
        }

        @Override
        public boolean doVillagersTakeOffenseAtMindMurder() {
            return (Boolean)this.villagersOffendedByMindMurder.getValue();
        }
    }
}

