/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientBlock;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientBlockState;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientBlocks;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientTag;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientTagExcluding;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;

public class StateIngredientHelper {
    public static StateIngredient of(class_2248 block) {
        return new StateIngredientBlock(block);
    }

    public static StateIngredient of(class_2680 state) {
        return new StateIngredientBlockState(state);
    }

    public static StateIngredient of(class_6862<class_2248> tag) {
        return StateIngredientHelper.of(tag.comp_327());
    }

    public static StateIngredient of(class_2960 id) {
        return new StateIngredientTag(id);
    }

    public static StateIngredient of(Collection<class_2248> blocks) {
        return new StateIngredientBlocks(blocks);
    }

    public static StateIngredient tagExcluding(class_6862<class_2248> tag, StateIngredient ... excluded) {
        return new StateIngredientTagExcluding(tag.comp_327(), List.of(excluded));
    }

    public static StateIngredient deserialize(JsonObject object) {
        switch (class_3518.method_15265((JsonObject)object, (String)"type")) {
            case "tag": {
                return new StateIngredientTag(new class_2960(class_3518.method_15265((JsonObject)object, (String)"tag")));
            }
            case "block": {
                return new StateIngredientBlock((class_2248)class_2378.field_11146.method_10223(new class_2960(class_3518.method_15265((JsonObject)object, (String)"block"))));
            }
            case "state": {
                return new StateIngredientBlockState(StateIngredientHelper.readBlockState(object));
            }
            case "blocks": {
                ArrayList<class_2248> blocks = new ArrayList<class_2248>();
                for (JsonElement element : class_3518.method_15261((JsonObject)object, (String)"blocks")) {
                    blocks.add((class_2248)class_2378.field_11146.method_10223(new class_2960(element.getAsString())));
                }
                return new StateIngredientBlocks(blocks);
            }
            case "tag_excluding": {
                class_2960 tag = new class_2960(class_3518.method_15265((JsonObject)object, (String)"tag"));
                ArrayList<StateIngredient> ingr = new ArrayList<StateIngredient>();
                for (JsonElement element : class_3518.method_15261((JsonObject)object, (String)"exclude")) {
                    ingr.add(StateIngredientHelper.deserialize(class_3518.method_15295((JsonElement)element, (String)"exclude entry")));
                }
                return new StateIngredientTagExcluding(tag, ingr);
            }
        }
        throw new JsonParseException("Unknown type!");
    }

    @Nullable
    public static StateIngredient tryDeserialize(JsonObject object) {
        StateIngredient ingr = StateIngredientHelper.deserialize(object);
        if (ingr instanceof StateIngredientTag) {
            StateIngredientTag sit = (StateIngredientTag)ingr;
            if (sit.resolve().findAny().isEmpty()) {
                return null;
            }
            return ingr;
        }
        if (ingr instanceof StateIngredientBlock || ingr instanceof StateIngredientBlockState) {
            if (ingr.test(class_2246.field_10124.method_9564())) {
                return null;
            }
        } else if (ingr instanceof StateIngredientBlocks) {
            StateIngredientBlocks sib = (StateIngredientBlocks)ingr;
            ImmutableSet<class_2248> blocks = sib.blocks;
            ArrayList<class_2248> list = new ArrayList<class_2248>((Collection<class_2248>)blocks);
            if (list.removeIf(b -> b == class_2246.field_10124)) {
                if (list.size() == 0) {
                    return null;
                }
                return StateIngredientHelper.of(list);
            }
        }
        return ingr;
    }

    public static StateIngredient read(class_2540 buffer) {
        switch (buffer.method_10816()) {
            case 0: {
                int count = buffer.method_10816();
                HashSet<class_2248> set = new HashSet<class_2248>();
                for (int i = 0; i < count; ++i) {
                    int id = buffer.method_10816();
                    class_2248 block = (class_2248)class_2378.field_11146.method_10200(id);
                    set.add(block);
                }
                return new StateIngredientBlocks(set);
            }
            case 1: {
                return new StateIngredientBlock((class_2248)class_2378.field_11146.method_10200(buffer.method_10816()));
            }
            case 2: {
                return new StateIngredientBlockState(class_2248.method_9531((int)buffer.method_10816()));
            }
        }
        throw new IllegalArgumentException("Unknown input discriminator!");
    }

    public static JsonObject serializeBlockState(class_2680 state) {
        class_2487 nbt = class_2512.method_10686((class_2680)state);
        StateIngredientHelper.renameTag(nbt, "Name", "name");
        StateIngredientHelper.renameTag(nbt, "Properties", "properties");
        Dynamic dyn = new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static class_2680 readBlockState(JsonObject object) {
        class_2487 nbt = (class_2487)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object).convert((DynamicOps)class_2509.field_11560).getValue();
        StateIngredientHelper.renameTag(nbt, "name", "Name");
        StateIngredientHelper.renameTag(nbt, "properties", "Properties");
        String name = nbt.method_10558("Name");
        class_2960 id = class_2960.method_12829((String)name);
        if (id == null || !class_2378.field_11146.method_17966(id).isPresent()) {
            throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
        }
        return class_2512.method_10681((class_2487)nbt);
    }

    @Deprecated
    @Nonnull
    public static List<class_1799> toStackList(StateIngredient input) {
        return input.getDisplayedStacks();
    }

    private static void renameTag(class_2487 tag, String from, String to) {
        class_2520 t = tag.method_10580(from);
        if (t != null) {
            tag.method_10551(from);
            tag.method_10566(to, t);
        }
    }
}

