/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemSpellbook;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public record MsgShiftScrollSyn(class_1268 hand, double scrollDelta, boolean isCtrl) implements IMessage
{
    public static final class_2960 ID = HexAPI.modLoc("scroll");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    public static MsgShiftScrollSyn deserialize(ByteBuf buffer) {
        class_2540 buf = new class_2540(buffer);
        class_1268 hand = (class_1268)buf.method_10818(class_1268.class);
        double scrollDelta = buf.readDouble();
        boolean isCtrl = buf.readBoolean();
        return new MsgShiftScrollSyn(hand, scrollDelta, isCtrl);
    }

    @Override
    public void serialize(class_2540 buf) {
        buf.method_10817((Enum)this.hand);
        buf.writeDouble(this.scrollDelta);
        buf.writeBoolean(this.isCtrl);
    }

    public void handle(MinecraftServer server, class_3222 sender) {
        class_1799 stack = sender.method_5998(this.hand);
        if (stack.method_7909() == HexItems.SPELLBOOK) {
            this.spellbook(sender, stack);
        } else if (stack.method_7909() == HexItems.ABACUS) {
            this.abacus(sender, stack);
        }
    }

    private void spellbook(class_3222 sender, class_1799 stack) {
        int newIdx = ItemSpellbook.RotatePageIdx(stack, this.scrollDelta < 0.0);
        int len = ItemSpellbook.HighestPage(stack);
        boolean sealed = ItemSpellbook.IsSealed(stack);
        class_2588 component = this.hand == class_1268.field_5810 && stack.method_7938() ? (sealed ? new class_2588("hexcasting.tooltip.spellbook.page_with_name.sealed", new Object[]{new class_2585(String.valueOf(newIdx)).method_27692(class_124.field_1068), new class_2585(String.valueOf(len)).method_27692(class_124.field_1068), new class_2585("").method_27695(new class_124[]{stack.method_7932().field_8908, class_124.field_1056}).method_10852(stack.method_7964()), new class_2588("hexcasting.tooltip.spellbook.sealed").method_27692(class_124.field_1065)}) : new class_2588("hexcasting.tooltip.spellbook.page_with_name", new Object[]{new class_2585(String.valueOf(newIdx)).method_27692(class_124.field_1068), new class_2585(String.valueOf(len)).method_27692(class_124.field_1068), new class_2585("").method_27695(new class_124[]{stack.method_7932().field_8908, class_124.field_1056}).method_10852(stack.method_7964())})) : (sealed ? new class_2588("hexcasting.tooltip.spellbook.page.sealed", new Object[]{new class_2585(String.valueOf(newIdx)).method_27692(class_124.field_1068), new class_2585(String.valueOf(len)).method_27692(class_124.field_1068), new class_2588("hexcasting.tooltip.spellbook.sealed").method_27692(class_124.field_1065)}) : new class_2588("hexcasting.tooltip.spellbook.page", new Object[]{new class_2585(String.valueOf(newIdx)).method_27692(class_124.field_1068), new class_2585(String.valueOf(len)).method_27692(class_124.field_1068)}));
        sender.method_7353((class_2561)component.method_27692(class_124.field_1080), true);
    }

    private void abacus(class_3222 sender, class_1799 stack) {
        float pitch;
        double delta;
        boolean increase = this.scrollDelta < 0.0;
        double num = NBTHelper.getDouble(stack, "value");
        if (this.hand == class_1268.field_5808) {
            delta = this.isCtrl ? 10.0 : 1.0;
            pitch = this.isCtrl ? 0.7f : 0.9f;
        } else {
            delta = this.isCtrl ? 0.01 : 0.1;
            pitch = this.isCtrl ? 1.3f : 1.0f;
        }
        NBTHelper.putDouble(stack, "value", num += delta * (double)(increase ? 1 : -1));
        pitch *= increase ? 1.05f : 0.95f;
        pitch = (float)((double)pitch + (Math.random() - 0.5) * 0.1);
        sender.field_6002.method_8465(null, sender.method_23317(), sender.method_23318(), sender.method_23321(), HexSounds.ABACUS, class_3419.field_15248, 0.5f, pitch);
        class_2487 datumTag = HexItems.ABACUS.readDatumTag(stack);
        if (datumTag != null) {
            class_2561 popup = SpellDatum.displayFromNBT(datumTag);
            sender.method_7353((class_2561)new class_2588("hexcasting.tooltip.abacus", new Object[]{popup}).method_27692(class_124.field_1060), true);
        }
    }
}

