/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.mod.HexItemTags;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.common.network.MsgNewSpellPatternAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public record MsgNewSpellPatternSyn(class_1268 handUsed, HexPattern pattern, List<ResolvedPattern> resolvedPatterns) implements IMessage
{
    public static final class_2960 ID = HexAPI.modLoc("pat_cs");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    public static MsgNewSpellPatternSyn deserialize(ByteBuf buffer) {
        class_2540 buf = new class_2540(buffer);
        class_1268 hand = (class_1268)buf.method_10818(class_1268.class);
        HexPattern pattern = HexPattern.fromNBT(buf.method_30617());
        int resolvedPatternsLen = buf.readInt();
        ArrayList<ResolvedPattern> resolvedPatterns = new ArrayList<ResolvedPattern>(resolvedPatternsLen);
        for (int i = 0; i < resolvedPatternsLen; ++i) {
            resolvedPatterns.add(ResolvedPattern.fromNBT(buf.method_30617()));
        }
        return new MsgNewSpellPatternSyn(hand, pattern, resolvedPatterns);
    }

    @Override
    public void serialize(class_2540 buf) {
        buf.method_10817((Enum)this.handUsed);
        buf.method_10794(this.pattern.serializeToNBT());
        buf.writeInt(this.resolvedPatterns.size());
        for (ResolvedPattern pat : this.resolvedPatterns) {
            buf.method_10794(pat.serializeToNBT());
        }
    }

    public void handle(MinecraftServer server, class_3222 sender) {
        class_1799 held = sender.method_5998(this.handUsed);
        if (held.method_31573(HexItemTags.WANDS)) {
            ControllerInfo clientInfo;
            boolean autoFail = false;
            if (!this.resolvedPatterns.isEmpty()) {
                ArrayList<HexCoord> allPoints = new ArrayList<HexCoord>();
                for (int i = 0; i < this.resolvedPatterns.size() - 1; ++i) {
                    ResolvedPattern pat = this.resolvedPatterns.get(i);
                    allPoints.addAll(pat.getPattern().positions(pat.getOrigin()));
                }
                ResolvedPattern currentResolvedPattern = this.resolvedPatterns.get(this.resolvedPatterns.size() - 1);
                List<HexCoord> currentSpellPoints = currentResolvedPattern.getPattern().positions(currentResolvedPattern.getOrigin());
                if (currentSpellPoints.stream().anyMatch(allPoints::contains)) {
                    autoFail = true;
                }
            }
            sender.method_7281(HexStatistics.PATTERNS_DRAWN);
            CastingHarness harness = IXplatAbstractions.INSTANCE.getHarness(sender, this.handUsed);
            if (autoFail) {
                clientInfo = new ControllerInfo(false, harness.getStack().isEmpty(), ResolvedPatternType.INVALID, harness.generateDescs());
            } else {
                clientInfo = harness.executeIota(SpellDatum.make(this.pattern), sender.method_14220());
                if (clientInfo.getMakesCastSound()) {
                    sender.field_6002.method_8465(null, sender.method_23317(), sender.method_23318(), sender.method_23321(), HexSounds.ACTUALLY_CAST, class_3419.field_15248, 1.0f, 1.0f + ((float)Math.random() - 0.5f) * 0.2f);
                }
            }
            if (clientInfo.isStackClear()) {
                IXplatAbstractions.INSTANCE.setHarness(sender, null);
                IXplatAbstractions.INSTANCE.setPatterns(sender, List.of());
            } else {
                IXplatAbstractions.INSTANCE.setHarness(sender, harness);
                if (!this.resolvedPatterns.isEmpty()) {
                    this.resolvedPatterns.get(this.resolvedPatterns.size() - 1).setType(clientInfo.getResolutionType());
                }
                IXplatAbstractions.INSTANCE.setPatterns(sender, this.resolvedPatterns);
            }
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(sender, new MsgNewSpellPatternAck(clientInfo));
        }
    }
}

