/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public record MsgCastParticleAck(ParticleSpray spray, FrozenColorizer colorizer) implements IMessage
{
    public static final class_2960 ID = HexAPI.modLoc("cprtcl");
    private static final Random RANDOM = new Random();

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    public static MsgCastParticleAck deserialize(ByteBuf buffer) {
        class_2540 buf = new class_2540(buffer);
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double velX = buf.readDouble();
        double velY = buf.readDouble();
        double velZ = buf.readDouble();
        double fuzziness = buf.readDouble();
        double spread = buf.readDouble();
        int count = buf.readInt();
        class_2487 tag = buf.method_30617();
        FrozenColorizer colorizer = FrozenColorizer.fromNBT(tag);
        return new MsgCastParticleAck(new ParticleSpray(new class_243(posX, posY, posZ), new class_243(velX, velY, velZ), fuzziness, spread, count), colorizer);
    }

    @Override
    public void serialize(class_2540 buf) {
        buf.writeDouble(this.spray.getPos().field_1352);
        buf.writeDouble(this.spray.getPos().field_1351);
        buf.writeDouble(this.spray.getPos().field_1350);
        buf.writeDouble(this.spray.getVel().field_1352);
        buf.writeDouble(this.spray.getVel().field_1351);
        buf.writeDouble(this.spray.getVel().field_1350);
        buf.writeDouble(this.spray.getFuzziness());
        buf.writeDouble(this.spray.getSpread());
        buf.writeInt(this.spray.getCount());
        buf.method_10794(this.colorizer.serializeToNBT());
    }

    private static class_243 randomInCircle(double maxTh) {
        double th = RANDOM.nextDouble(0.0, maxTh + 0.001);
        double z = RANDOM.nextDouble(-1.0, 1.0);
        return new class_243(Math.sqrt(1.0 - z * z) * Math.cos(th), Math.sqrt(1.0 - z * z) * Math.sin(th), z);
    }

    public static void handle(final MsgCastParticleAck msg) {
        class_310.method_1551().execute(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < msg.spray().getCount(); ++i) {
                    int color = msg.colorizer().getColor(RANDOM.nextFloat() * 256.0f, class_243.field_1353);
                    class_243 offset = MsgCastParticleAck.randomInCircle(6.2831854820251465).method_1029().method_1021((double)RANDOM.nextFloat() * msg.spray().getSpread() / 2.0);
                    class_243 pos = msg.spray().getPos().method_1019(offset);
                    double phi = Math.acos(1.0 - RANDOM.nextDouble() * (1.0 - Math.cos(msg.spray().getSpread())));
                    double theta = Math.PI * 2 * RANDOM.nextDouble();
                    class_243 v = msg.spray().getVel().method_1029();
                    class_243 k = v.field_1352 == 0.0 && v.field_1351 == 0.0 ? new class_243(1.0, 0.0, 0.0) : v.method_1036(new class_243(0.0, 0.0, 1.0));
                    class_243 velUnlen = v.method_1021(Math.cos(phi)).method_1019(k.method_1021(Math.sin(phi) * Math.cos(theta))).method_1019(v.method_1036(k).method_1021(Math.sin(phi) * Math.sin(theta)));
                    class_243 vel = velUnlen.method_1021(msg.spray().getVel().method_1033() / 20.0);
                    class_310.method_1551().field_1687.method_8406((class_2394)new ConjureParticleOptions(color, false), pos.field_1352, pos.field_1351, pos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                }
            }
        });
    }
}

