/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemManaHolder;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import org.jetbrains.annotations.Nullable;

public abstract class ItemPackagedHex
extends ItemManaHolder
implements HexHolderItem {
    public static final String TAG_PATTERNS = "patterns";
    public static final class_2960 HAS_PATTERNS_PRED = HexAPI.modLoc("has_patterns");

    public ItemPackagedHex(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public abstract boolean breakAfterDepletion();

    @Override
    public boolean canRecharge(class_1799 stack) {
        return !this.breakAfterDepletion();
    }

    @Override
    public boolean manaProvider(class_1799 stack) {
        return false;
    }

    @Override
    public boolean hasHex(class_1799 stack) {
        return NBTHelper.hasList(stack, TAG_PATTERNS, (byte)10);
    }

    @Override
    @Nullable
    public List<SpellDatum<?>> getHex(class_1799 stack, class_3218 level) {
        class_2499 patsTag = NBTHelper.getList(stack, TAG_PATTERNS, 10);
        if (patsTag == null) {
            return null;
        }
        ArrayList out = new ArrayList();
        for (class_2520 patTag : patsTag) {
            class_2487 tag = NBTHelper.getAsCompound(patTag);
            if (tag.method_10546() != 1) {
                out.add(SpellDatum.make(HexPattern.fromNBT(tag)));
                continue;
            }
            out.add(SpellDatum.fromNBT(tag, level));
        }
        return out;
    }

    @Override
    public void writeHex(class_1799 stack, List<SpellDatum<?>> patterns, int mana) {
        class_2499 patsTag = new class_2499();
        for (SpellDatum<?> pat : patterns) {
            patsTag.add((Object)pat.serializeToNBT());
        }
        NBTHelper.putList(stack, TAG_PATTERNS, patsTag);
        ItemPackagedHex.withMana(stack, mana, mana);
    }

    @Override
    public void clearHex(class_1799 stack) {
        NBTHelper.remove(stack, TAG_PATTERNS);
        NBTHelper.remove(stack, "hexcasting:mana");
        NBTHelper.remove(stack, "hexcasting:start_mana");
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (!this.hasHex(stack)) {
            return class_1271.method_22431((Object)stack);
        }
        if (world.field_9236) {
            return class_1271.method_22427((Object)stack);
        }
        List<SpellDatum<?>> instrs = this.getHex(stack, (class_3218)world);
        if (instrs == null) {
            return class_1271.method_22431((Object)stack);
        }
        class_3222 sPlayer = (class_3222)player;
        CastingContext ctx = new CastingContext(sPlayer, usedHand);
        CastingHarness harness = new CastingHarness(ctx);
        ControllerInfo info = harness.executeIotas(instrs, sPlayer.method_14220());
        boolean broken = this.breakAfterDepletion() && this.getMana(stack) == 0;
        class_3445 stat = broken ? class_3468.field_15383.method_14956((Object)this) : class_3468.field_15372.method_14956((Object)this);
        player.method_7259(stat);
        sPlayer.method_7357().method_7906((class_1792)this, 5);
        sPlayer.field_6002.method_8465(null, sPlayer.method_23317(), sPlayer.method_23318(), sPlayer.method_23321(), HexSounds.ACTUALLY_CAST, class_3419.field_15248, 1.0f, 1.0f + ((float)Math.random() - 0.5f) * 0.2f);
        if (broken) {
            stack.method_7934(1);
            player.method_20236(usedHand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22427((Object)stack);
    }

    public int method_7881(class_1799 pStack) {
        return 16;
    }

    public class_1839 method_7853(class_1799 pStack) {
        return class_1839.field_8949;
    }
}

