/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipGreeble;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public class ItemSlate
extends class_1747
implements DataHolderItem {
    public static final class_2960 WRITTEN_PRED = HexAPI.modLoc("written");

    public ItemSlate(class_2248 pBlock, class_1792.class_1793 pProperties) {
        super(pBlock, pProperties);
    }

    public class_2561 method_7864(class_1799 pStack) {
        String key = "block.hexcasting.slate." + (ItemSlate.hasPattern(pStack) ? "written" : "blank");
        return new class_2588(key);
    }

    public static boolean hasPattern(class_1799 stack) {
        class_2487 bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet != null) {
            return bet.method_10573("pattern", 10) && !bet.method_10562("pattern").method_33133();
        }
        return false;
    }

    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (!ItemSlate.hasPattern(stack)) {
            NBTHelper.remove(stack, "BlockEntityTag");
        }
        return false;
    }

    public void method_7888(class_1799 pStack, class_1937 pLevel, class_1297 pEntity, int pSlotId, boolean pIsSelected) {
        if (!ItemSlate.hasPattern(pStack)) {
            NBTHelper.remove(pStack, "BlockEntityTag");
        }
    }

    @Override
    @Nullable
    public class_2487 readDatumTag(class_1799 stack) {
        class_2487 bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet == null || !bet.method_10573("pattern", 10)) {
            return null;
        }
        class_2487 patTag = bet.method_10562("pattern");
        if (patTag.method_33133()) {
            return null;
        }
        class_2487 out = new class_2487();
        out.method_10566("pattern", (class_2520)patTag);
        return out;
    }

    @Override
    public boolean canWrite(class_1799 stack, SpellDatum<?> datum) {
        return datum == null || datum.getType() == DatumType.PATTERN;
    }

    @Override
    public void writeDatum(class_1799 stack, SpellDatum<?> datum) {
        if (this.canWrite(stack, datum)) {
            if (datum == null) {
                class_2487 beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                beTag.method_10551("pattern");
                if (beTag.method_33133()) {
                    NBTHelper.remove(stack, "BlockEntityTag");
                }
            } else {
                Object beTag = datum.getPayload();
                if (beTag instanceof HexPattern) {
                    HexPattern pat = (HexPattern)beTag;
                    beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                    beTag.method_10566("pattern", (class_2520)pat.serializeToNBT());
                }
            }
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2487 patTag;
        class_2487 bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet != null && bet.method_10573("pattern", 10) && !(patTag = bet.method_10562("pattern")).method_33133()) {
            HexPattern pattern = HexPattern.fromNBT(patTag);
            return Optional.of(new PatternTooltipGreeble(pattern, PatternTooltipGreeble.SLATE_BG));
        }
        return Optional.empty();
    }
}

