/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.command.PatternResLocArgument;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ListPatternsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hexcasting:patterns").requires(dp -> dp.method_9259(3))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            Map<String, Pair<class_2960, HexDir>> lookup = PatternRegistry.getPerWorldPatterns(((class_2168)ctx.getSource()).method_9225());
            List listing = lookup.entrySet().stream().sorted((a, b) -> ListPatternsCommand.compareResLoc((class_2960)((Pair)a.getValue()).getFirst(), (class_2960)((Pair)b.getValue()).getFirst())).toList();
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("command.hexcasting.pats.listing"), false);
            for (Map.Entry pair : listing) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(((class_2960)((Pair)pair.getValue()).getFirst()).toString()).method_27693(": ").method_10852(SpellDatum.make(HexPattern.fromAngles((String)pair.getKey(), (HexDir)((Object)((Object)((Pair)pair.getValue()).getSecond())))).display()), false);
            }
            return lookup.size();
        }))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"patternName", (ArgumentType)PatternResLocArgument.id()).executes(ctx -> {
            class_1297 sender = ((class_2168)ctx.getSource()).method_9228();
            if (sender instanceof class_3222) {
                class_3222 player = (class_3222)sender;
                class_2960 targetId = class_2232.method_9443((CommandContext)ctx, (String)"patternName");
                HexPattern pat = PatternResLocArgument.getPattern((CommandContext<class_2168>)ctx, "patternName");
                class_2487 tag = new class_2487();
                tag.method_10582("op_id", targetId.toString());
                tag.method_10566("pattern", (class_2520)pat.serializeToNBT());
                class_1799 stack = new class_1799((class_1935)HexItems.SCROLL);
                stack.method_7980(tag);
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("command.hexcasting.pats.specific.success", new Object[]{stack.method_7954(), targetId}), true);
                class_1542 stackEntity = player.method_7328(stack, false);
                if (stackEntity != null) {
                    stackEntity.method_6975();
                    stackEntity.method_6984(player.method_5667());
                }
                return 1;
            }
            return 0;
        })))).then(class_2170.method_9247((String)"giveAll").executes(ctx -> {
            class_1297 sender = ((class_2168)ctx.getSource()).method_9228();
            if (sender instanceof class_3222) {
                class_3222 player = (class_3222)sender;
                Map<String, Pair<class_2960, HexDir>> lookup = PatternRegistry.getPerWorldPatterns(((class_2168)ctx.getSource()).method_9225());
                lookup.forEach((pattern, entry) -> {
                    class_2960 opId = (class_2960)entry.component1();
                    HexDir startDir = (HexDir)((Object)((Object)((Object)entry.component2())));
                    class_2487 tag = new class_2487();
                    tag.method_10582("op_id", opId.toString());
                    tag.method_10566("pattern", (class_2520)HexPattern.fromAngles(pattern, startDir).serializeToNBT());
                    class_1799 stack = new class_1799((class_1935)HexItems.SCROLL);
                    stack.method_7980(tag);
                    class_1542 stackEntity = player.method_7328(stack, false);
                    if (stackEntity != null) {
                        stackEntity.method_6975();
                        stackEntity.method_6984(player.method_5667());
                    }
                });
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("command.hexcasting.pats.all", new Object[]{lookup.size()}), true);
                return lookup.size();
            }
            return 0;
        })));
    }

    private static int compareResLoc(class_2960 a, class_2960 b) {
        int ns = a.method_12836().compareTo(b.method_12836());
        if (ns != 0) {
            return ns;
        }
        return a.method_12832().compareTo(b.method_12832());
    }
}

