/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicFloodfiller;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class BlockEntityAkashicRecord
extends HexBlockEntity {
    public static final String TAG_LOOKUP = "lookup";
    public static final String TAG_POS = "pos";
    public static final String TAG_DATUM = "datum";
    public static final String TAG_DIR = "dir";
    private final Map<String, Entry> entries = new HashMap<String, Entry>();

    public BlockEntityAkashicRecord(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(HexBlockEntities.AKASHIC_RECORD_TILE, pWorldPosition, pBlockState);
    }

    public void removeFloodfillerAt(class_2338 pos) {
        this.revalidateAllBookshelves();
    }

    @Nullable
    public class_2338 addNewDatum(HexPattern key, SpellDatum<?> datum) {
        String entryKey = this.getKey(key);
        if (this.entries.containsKey(entryKey)) {
            return null;
        }
        class_2338 openPos = BlockAkashicFloodfiller.floodFillFor(this.field_11867, this.field_11863, (pos, bs, world) -> {
            BlockEntityAkashicBookshelf tile;
            class_2586 patt2056$temp = world.method_8321(pos);
            return patt2056$temp instanceof BlockEntityAkashicBookshelf && (tile = (BlockEntityAkashicBookshelf)patt2056$temp).getPattern() == null;
        });
        if (openPos != null) {
            BlockEntityAkashicBookshelf tile = (BlockEntityAkashicBookshelf)this.field_11863.method_8321(openPos);
            tile.setNewData(this.method_11016(), key, datum.getType());
            this.entries.put(entryKey, new Entry(openPos, key.getStartDir(), datum.serializeToNBT()));
            this.sync();
            return openPos;
        }
        return null;
    }

    private String getKey(HexPattern key) {
        String angles = key.anglesSignature();
        if (angles.isEmpty()) {
            return "empty";
        }
        return angles;
    }

    @Nullable
    public SpellDatum<?> lookupPattern(HexPattern key, class_3218 slevel) {
        Entry entry = this.entries.get(this.getKey(key));
        if (entry == null) {
            return null;
        }
        return SpellDatum.fromNBT(entry.datum, slevel);
    }

    public class_2561 getDisplayAt(HexPattern key) {
        Entry entry = this.entries.get(this.getKey(key));
        if (entry != null) {
            return SpellDatum.displayFromNBT(entry.datum);
        }
        return new class_2588("hexcasting.spelldata.akashic.nopos").method_27692(class_124.field_1061);
    }

    public int getCount() {
        return this.entries.size();
    }

    public void revalidateAllBookshelves() {
        HashSet<class_2338> validPoses = new HashSet<class_2338>();
        HashSet<class_2338> seen = new HashSet<class_2338>();
        ArrayDeque<class_2338> todo = new ArrayDeque<class_2338>();
        todo.add(this.field_11867);
        while (!todo.isEmpty()) {
            class_2338 here = (class_2338)todo.remove();
            for (class_2350 dir : class_2350.values()) {
                class_2680 bs;
                class_2338 neighbor = here.method_10093(dir);
                if (!seen.add(neighbor) || !BlockAkashicFloodfiller.canItBeFloodedThrough(neighbor, bs = this.field_11863.method_8320(neighbor), this.field_11863)) continue;
                todo.add(neighbor);
                if (!(this.field_11863.method_8321(neighbor) instanceof BlockEntityAkashicBookshelf) || !bs.method_28498(BlockAkashicBookshelf.DATUM_TYPE) || bs.method_11654(BlockAkashicBookshelf.DATUM_TYPE) == DatumType.EMPTY) continue;
                validPoses.add(neighbor);
            }
        }
        ArrayList<String> sigs = new ArrayList<String>(this.entries.keySet());
        for (String sig : sigs) {
            Entry entry = this.entries.get(sig);
            if (validPoses.contains(entry.pos)) continue;
            this.entries.remove(sig);
            class_2586 class_25862 = this.field_11863.method_8321(entry.pos);
            if (!(class_25862 instanceof BlockEntityAkashicBookshelf)) continue;
            BlockEntityAkashicBookshelf shelf = (BlockEntityAkashicBookshelf)class_25862;
            shelf.setNewData(null, null, DatumType.EMPTY);
        }
        this.sync();
    }

    @Override
    protected void saveModData(class_2487 compoundTag) {
        class_2487 lookupTag = new class_2487();
        this.entries.forEach((sig, entry) -> {
            class_2487 t = new class_2487();
            t.method_10566(TAG_POS, (class_2520)class_2512.method_10692((class_2338)entry.pos));
            t.method_10566(TAG_DATUM, (class_2520)entry.datum);
            t.method_10567(TAG_DIR, (byte)entry.startDir.ordinal());
            lookupTag.method_10566(sig, (class_2520)t);
        });
        compoundTag.method_10566(TAG_LOOKUP, (class_2520)lookupTag);
    }

    @Override
    protected void loadModData(class_2487 compoundTag) {
        class_2487 lookupTag = compoundTag.method_10562(TAG_LOOKUP);
        this.entries.clear();
        Set sigs = lookupTag.method_10541();
        for (String sig : sigs) {
            class_2487 entryTag = lookupTag.method_10562(sig);
            class_2338 pos = class_2512.method_10691((class_2487)entryTag.method_10562(TAG_POS));
            HexDir dir = HexDir.values()[entryTag.method_10571(TAG_DIR)];
            class_2487 datum = entryTag.method_10562(TAG_DATUM);
            this.entries.put(sig, new Entry(pos, dir, datum));
        }
    }

    private record Entry(class_2338 pos, HexDir startDir, class_2487 datum) {
    }
}

