/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.HexTooltips;
import at.petrak.hexcasting.client.be.BlockEntityAkashicBookshelfRenderer;
import at.petrak.hexcasting.client.be.BlockEntitySlateRenderer;
import at.petrak.hexcasting.client.entity.WallScrollRenderer;
import at.petrak.hexcasting.client.particles.ConjureParticle;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicRecord;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.items.ItemSlate;
import at.petrak.hexcasting.common.items.ItemWand;
import at.petrak.hexcasting.common.items.magic.ItemManaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexParticles;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2428;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2487;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2747;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_5251;
import net.minecraft.class_5614;
import org.jetbrains.annotations.NotNull;

public class RegisterClientStuff {
    public static void init() {
        RegisterClientStuff.registerDataHolderOverrides(HexItems.FOCUS);
        RegisterClientStuff.registerDataHolderOverrides(HexItems.SPELLBOOK);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.CYPHER);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.TRINKET);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.ARTIFACT);
        IClientXplatAbstractions x = IClientXplatAbstractions.INSTANCE;
        x.registerItemProperty(HexItems.BATTERY, ItemManaBattery.MANA_PREDICATE, (stack, level, holder, holderID) -> {
            ManaHolderItem item = (ManaHolderItem)stack.method_7909();
            return item.getManaFullness(stack);
        });
        x.registerItemProperty(HexItems.BATTERY, ItemManaBattery.MAX_MANA_PREDICATE, (stack, level, holder, holderID) -> {
            ItemManaBattery item = (ItemManaBattery)stack.method_7909();
            int max = item.getMaxMana(stack);
            return (float)Math.sqrt((float)max / 100000.0f / 10.0f);
        });
        x.registerItemProperty(HexItems.SCROLL, ItemScroll.ANCIENT_PREDICATE, (stack, level, holder, holderID) -> NBTHelper.hasString(stack, "op_id") ? 1.0f : 0.0f);
        x.registerItemProperty((class_1792)HexItems.SLATE, ItemSlate.WRITTEN_PRED, (stack, level, holder, holderID) -> ItemSlate.hasPattern(stack) ? 1.0f : 0.0f);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_BIRCH);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_SPRUCE);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_JUNGLE);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_DARK_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_ACACIA);
        RegisterClientStuff.registerWandOverrides(HexItems.WAND_AKASHIC);
        HexTooltips.init();
        x.setRenderLayer(HexBlocks.CONJURED_LIGHT, class_1921.method_23581());
        x.setRenderLayer(HexBlocks.CONJURED_BLOCK, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.AKASHIC_DOOR, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.AKASHIC_TRAPDOOR, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.SCONCE, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.AKASHIC_LEAVES1, class_1921.method_23579());
        x.setRenderLayer((class_2248)HexBlocks.AKASHIC_LEAVES2, class_1921.method_23579());
        x.setRenderLayer((class_2248)HexBlocks.AKASHIC_LEAVES3, class_1921.method_23579());
        x.setRenderLayer(HexBlocks.AKASHIC_RECORD, class_1921.method_23583());
        x.registerEntityRenderer(HexEntities.WALL_SCROLL, WallScrollRenderer::new);
        RegisterClientStuff.addScryingLensStuff();
    }

    private static void addScryingLensStuff() {
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction, lensHand) -> state.method_26204() instanceof BlockAbstractImpetus, (lines, state, pos, observer, world, direction, lensHand) -> {
            class_2586 patt5601$temp = world.method_8321(pos);
            if (patt5601$temp instanceof BlockEntityAbstractImpetus) {
                BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)patt5601$temp;
                beai.applyScryingLensOverlay(lines, state, pos, observer, world, direction, lensHand);
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10179, (lines, state, pos, observer, world, direction, lensHand) -> {
            int note = (Integer)state.method_11654((class_2769)class_2428.field_11324);
            float rCol = Math.max(0.0f, class_3532.method_15374((float)(((float)note / 24.0f + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float gCol = Math.max(0.0f, class_3532.method_15374((float)(((float)note / 24.0f + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float bCol = Math.max(0.0f, class_3532.method_15374((float)(((float)note / 24.0f + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            int noteColor = 0xFF000000 | class_3532.method_15353((float)rCol, (float)gCol, (float)bCol);
            class_2766 instrument = (class_2766)state.method_11654((class_2769)class_2428.field_11325);
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8623), (Object)new class_2585(String.valueOf(instrument.ordinal())).method_27694(RegisterClientStuff.color(RegisterClientStuff.instrumentColor(instrument)))));
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8643), (Object)new class_2585(String.valueOf(note)).method_27694(RegisterClientStuff.color(noteColor))));
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_BOOKSHELF, (lines, state, pos, observer, world, direction, lensHand) -> {
            class_2586 patt7134$temp = world.method_8321(pos);
            if (patt7134$temp instanceof BlockEntityAkashicBookshelf) {
                BlockEntityAkashicBookshelf tile = (BlockEntityAkashicBookshelf)patt7134$temp;
                class_2338 recordPos = tile.getRecordPos();
                HexPattern pattern = tile.getPattern();
                if (recordPos != null && pattern != null) {
                    lines.add(new Pair((Object)new class_1799((class_1935)HexBlocks.AKASHIC_RECORD), (Object)new class_2588("hexcasting.tooltip.lens.akashic.bookshelf.location", new Object[]{recordPos.method_23854()})));
                    class_2586 patt7693$temp = world.method_8321(recordPos);
                    if (patt7693$temp instanceof BlockEntityAkashicRecord) {
                        BlockEntityAkashicRecord record = (BlockEntityAkashicRecord)patt7693$temp;
                        lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8529), (Object)record.getDisplayAt(pattern)));
                    }
                }
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_RECORD, (lines, state, pos, observer, world, direction, lensHand) -> {
            class_2586 patt8125$temp = world.method_8321(pos);
            if (patt8125$temp instanceof BlockEntityAkashicRecord) {
                BlockEntityAkashicRecord tile = (BlockEntityAkashicRecord)patt8125$temp;
                int count = tile.getCount();
                lines.add(new Pair((Object)new class_1799((class_1935)HexBlocks.AKASHIC_BOOKSHELF), (Object)new class_2588("hexcasting.tooltip.lens.akashic.record.count" + (count == 1 ? ".single" : ""), new Object[]{count})));
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10377, (lines, state, pos, observer, world, direction, lensHand) -> {
            int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(true);
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8725), (Object)new class_2585(comparatorValue == -1 ? "" : String.valueOf(comparatorValue)).method_27694(RegisterClientStuff.redstoneColor(comparatorValue))));
            boolean compare = state.method_11654((class_2769)class_2286.field_10789) == class_2747.field_12576;
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8530), (Object)new class_2585(compare ? ">=" : "-").method_27694(RegisterClientStuff.redstoneColor(compare ? 0 : 15))));
        });
        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10450, (lines, state, pos, observer, world, direction, lensHand) -> lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8557), (Object)new class_2585(String.valueOf(state.method_11654((class_2769)class_2462.field_11451))).method_27692(class_124.field_1054))));
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction, lensHand) -> state.method_26219() && !state.method_27852(class_2246.field_10377), (lines, state, pos, observer, world, direction, lensHand) -> {
            int signalStrength = 0;
            if (state.method_26204() instanceof class_2457) {
                signalStrength = (Integer)state.method_11654((class_2769)class_2457.field_11432);
            } else {
                for (class_2350 dir : class_2350.values()) {
                    signalStrength = Math.max(signalStrength, state.method_26195((class_1922)world, pos, dir));
                }
            }
            lines.add(0, new Pair((Object)new class_1799((class_1935)class_1802.field_8725), (Object)new class_2585(String.valueOf(signalStrength)).method_27694(RegisterClientStuff.redstoneColor(signalStrength))));
        });
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction, lensHand) -> state.method_26221(), (lines, state, pos, observer, world, direction, lensHand) -> {
            int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(false);
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8857), (Object)new class_2585(comparatorValue == -1 ? "" : String.valueOf(comparatorValue)).method_27694(RegisterClientStuff.redstoneColor(comparatorValue))));
        });
    }

    private static UnaryOperator<class_2583> color(int color) {
        return style -> style.method_27703(class_5251.method_27717((int)color));
    }

    private static UnaryOperator<class_2583> redstoneColor(int power) {
        return RegisterClientStuff.color(class_2457.method_10487((int)class_3532.method_15340((int)power, (int)0, (int)15)));
    }

    private static int instrumentColor(class_2766 instrument) {
        return switch (instrument) {
            case class_2766.field_12653 -> class_3620.field_16023.field_16011;
            case class_2766.field_12643, class_2766.field_12655, class_2766.field_18289 -> class_3620.field_15986.field_16011;
            case class_2766.field_12645 -> class_3620.field_16025.field_16011;
            case class_2766.field_12651 -> class_3620.field_15996.field_16011;
            case class_2766.field_12650 -> class_3620.field_15976.field_16011;
            case class_2766.field_12644 -> class_3620.field_15994.field_16011;
            case class_2766.field_12654 -> class_3620.field_15979.field_16011;
            case class_2766.field_12647 -> class_3620.field_16016.field_16011;
            case class_2766.field_18284 -> class_3620.field_16005.field_16011;
            case class_2766.field_18285 -> class_3620.field_15977.field_16011;
            case class_2766.field_18286 -> class_3620.field_15987.field_16011;
            case class_2766.field_18287 -> class_3620.field_16001.field_16011;
            case class_2766.field_18288 -> class_3620.field_16010.field_16011;
            default -> -1;
        };
    }

    private static void registerDataHolderOverrides(DataHolderItem item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty((class_1792)item, ItemFocus.DATATYPE_PRED, (stack, level, holder, holderID) -> {
            float f;
            class_2487 datum = item.readDatumTag(stack);
            String override = NBTHelper.getString(stack, "VisualOverride");
            String typename = null;
            if (override != null) {
                typename = override;
            } else if (datum != null) {
                typename = (String)datum.method_10541().iterator().next();
            }
            if (typename == null) {
                f = 0.0f;
            } else {
                switch (typename) {
                    case "entity": {
                        f = 1.0f;
                        break;
                    }
                    case "double": {
                        f = 2.0f;
                        break;
                    }
                    case "vec3": {
                        f = 3.0f;
                        break;
                    }
                    case "widget": {
                        f = 4.0f;
                        break;
                    }
                    case "list": {
                        f = 5.0f;
                        break;
                    }
                    case "pattern": {
                        f = 6.0f;
                        break;
                    }
                    default: {
                        f = 0.0f;
                    }
                }
            }
            return f;
        });
        IClientXplatAbstractions.INSTANCE.registerItemProperty((class_1792)item, ItemFocus.SEALED_PRED, (stack, level, holder, holderID) -> item.canWrite(stack, SpellDatum.make(Widget.NULL)) ? 0.0f : 1.0f);
    }

    private static void registerPackagedSpellOverrides(ItemPackagedHex item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemPackagedHex.HAS_PATTERNS_PRED, (stack, level, holder, holderID) -> item.hasHex(stack) ? 1.0f : 0.0f);
    }

    private static void registerWandOverrides(ItemWand item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemWand.FUNNY_LEVEL_PREDICATE, (stack, level, holder, holderID) -> {
            String name = stack.method_7964().getString().toLowerCase(Locale.ROOT);
            if (name.contains("old")) {
                return 1.0f;
            }
            if (name.contains("wand of the forest")) {
                return 2.0f;
            }
            return 0.0f;
        });
    }

    public static void registerParticles() {
        IClientXplatAbstractions.INSTANCE.registerParticleType(HexParticles.LIGHT_PARTICLE, ConjureParticle.Provider::new);
        IClientXplatAbstractions.INSTANCE.registerParticleType(HexParticles.CONJURE_PARTICLE, ConjureParticle.Provider::new);
    }

    public static void registerBlockEntityRenderers(@NotNull BlockEntityRendererRegisterererer registerer) {
        registerer.registerBlockEntityRenderer(HexBlockEntities.SLATE_TILE, BlockEntitySlateRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.AKASHIC_BOOKSHELF_TILE, BlockEntityAkashicBookshelfRenderer::new);
    }

    @FunctionalInterface
    public static interface BlockEntityRendererRegisterererer {
        public <T extends class_2586> void registerBlockEntityRenderer(class_2591<T> var1, class_5614<? super T> var2);
    }
}

