/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client;

import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class HexAdditionalRenderers {
    public static void overlayLevel(class_4587 ps, float partialTick) {
        Sentinel sentinel;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (sentinel = IXplatAbstractions.INSTANCE.getSentinel((class_1657)player)).hasSentinel() && player.method_37908().method_27983().equals(sentinel.dimension())) {
            HexAdditionalRenderers.renderSentinel(sentinel, player, ps, partialTick);
        }
    }

    public static void overlayGui(class_4587 ps, float partialTicks) {
        HexAdditionalRenderers.tryRenderScryingLensOverlay(ps, partialTicks);
    }

    private static void renderSentinel(Sentinel sentinel, class_746 owner, class_4587 ps, float partialTicks) {
        ps.method_22903();
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 playerPos = camera.method_19326();
        ps.method_22904(sentinel.position().field_1352 - playerPos.field_1352, sentinel.position().field_1351 - playerPos.field_1351, sentinel.position().field_1350 - playerPos.field_1350);
        float time = ClientTickCounter.total / 2.0f;
        float bobSpeed = 0.05f;
        float magnitude = 0.1f;
        ps.method_22904(0.0, (double)(class_3532.method_15374((float)(bobSpeed * time)) * magnitude), 0.0);
        float spinSpeed = 0.033333335f;
        ps.method_22907(class_1158.method_35826((class_1160)new class_1160(0.0f, spinSpeed * time, 0.0f)));
        if (sentinel.extendsRange()) {
            ps.method_22907(class_1158.method_35826((class_1160)new class_1160(spinSpeed * time / 8.0f, 0.0f, 0.0f)));
        }
        float scale = 0.5f;
        ps.method_22905(scale, scale, scale);
        class_289 tess = class_289.method_1348();
        class_287 buf = tess.method_1349();
        class_1159 neo = ps.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)5.0f);
        FrozenColorizer colorizer = IXplatAbstractions.INSTANCE.getColorizer((class_1657)owner);
        BiConsumer<float[], float[]> v = (l, r) -> {
            int lcolor = colorizer.getColor(time, new class_243((double)l[0], (double)l[1], (double)l[2]));
            int rcolor = colorizer.getColor(time, new class_243((double)r[0], (double)r[1], (double)r[2]));
            class_1160 normal = new class_1160(r[0] - l[0], r[1] - l[1], r[2] - l[2]);
            normal.method_4952();
            buf.method_22918(neo, l[0], l[1], l[2]).method_39415(lcolor).method_23763(ps.method_23760().method_23762(), normal.method_4943(), normal.method_4945(), normal.method_4947()).method_1344();
            buf.method_22918(neo, r[0], r[1], r[2]).method_39415(rcolor).method_23763(ps.method_23760().method_23762(), -normal.method_4943(), -normal.method_4945(), -normal.method_4947()).method_1344();
        };
        buf.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        for (int side = 0; side <= 1; ++side) {
            int i;
            float[][] ring = side == 0 ? Icos.BOTTOM_RING : Icos.TOP_RING;
            float[] apex = side == 0 ? Icos.BOTTOM : Icos.TOP;
            for (i = 0; i < 5; ++i) {
                v.accept(apex, ring[i]);
            }
            for (i = 0; i < 5; ++i) {
                v.accept(ring[i % 5], ring[(i + 1) % 5]);
            }
        }
        for (int i = 0; i < 5; ++i) {
            float[] bottom = Icos.BOTTOM_RING[i];
            v.accept(Icos.TOP_RING[(i + 2) % 5], bottom);
            v.accept(bottom, Icos.TOP_RING[(i + 3) % 5]);
        }
        tess.method_1350();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        ps.method_22909();
    }

    private static void tryRenderScryingLensOverlay(class_4587 ps, float partialTicks) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;
        if (player == null || level == null) {
            return;
        }
        boolean foundLens = false;
        class_1268 lensHand = null;
        for (class_1268 hand : class_1268.values()) {
            if (!player.method_5998(hand).method_31574((class_1792)HexItems.SCRYING_LENS)) continue;
            lensHand = hand;
            foundLens = true;
            break;
        }
        if (!foundLens && player.method_6118(class_1304.field_6169).method_31574((class_1792)HexItems.SCRYING_LENS)) {
            foundLens = true;
        }
        if (!foundLens) {
            return;
        }
        class_239 hitRes = mc.field_1765;
        if (hitRes != null && hitRes.method_17783() == class_239.class_240.field_1332) {
            class_3965 bhr = (class_3965)hitRes;
            class_2338 pos = bhr.method_17777();
            class_2680 bs = level.method_8320(pos);
            List<Pair<class_1799, class_2561>> lines = ScryingLensOverlayRegistry.getLines(bs, pos, player, level, bhr.method_17780(), lensHand);
            int totalHeight = 8;
            ArrayList actualLines = Lists.newArrayList();
            class_1041 window = mc.method_22683();
            int maxWidth = (int)((float)window.method_4486() / 2.0f * 0.8f);
            for (Pair<class_1799, class_2561> pair : lines) {
                Objects.requireNonNull(mc.field_1772);
                totalHeight += 9 + 6;
                class_2561 text = (class_2561)pair.getSecond();
                List textLines = mc.field_1772.method_27527().method_27495((class_5348)text, maxWidth, class_2583.field_24360);
                actualLines.add(Pair.of((Object)((class_1799)pair.getFirst()), (Object)textLines));
                if (textLines.size() <= 1) continue;
                Objects.requireNonNull(mc.field_1772);
                totalHeight += 9 * (textLines.size() - 1);
            }
            if (!lines.isEmpty()) {
                float x = (float)window.method_4486() / 2.0f + 8.0f;
                float y = (float)window.method_4502() / 2.0f - (float)totalHeight;
                ps.method_22903();
                ps.method_22904((double)x, (double)y, 0.0);
                for (Pair pair : actualLines) {
                    class_1799 stack = (class_1799)pair.getFirst();
                    if (!stack.method_7960()) {
                        RenderLib.renderItemStackInGui(ps, (class_1799)pair.getFirst(), 0, 0);
                    }
                    float tx = stack.method_7960() ? 0.0f : 18.0f;
                    float ty = 5.0f;
                    List text = (List)pair.getSecond();
                    for (class_5348 line : text) {
                        class_5481 actualLine = class_2477.method_10517().method_30934(line);
                        mc.field_1772.method_27517(ps, actualLine, tx, ty, -1);
                        Objects.requireNonNull(mc.field_1772);
                        ps.method_22904(0.0, 9.0, 0.0);
                    }
                    if (text.isEmpty()) {
                        Objects.requireNonNull(mc.field_1772);
                        ps.method_22904(0.0, 9.0, 0.0);
                    }
                    ps.method_22904(0.0, 6.0, 0.0);
                }
                ps.method_22909();
            }
        }
    }

    private static class Icos {
        public static float[] TOP = new float[]{0.0f, 1.0f, 0.0f};
        public static float[] BOTTOM = new float[]{0.0f, -1.0f, 0.0f};
        public static float[][] TOP_RING = new float[5][];
        public static float[][] BOTTOM_RING = new float[5][];

        private Icos() {
        }

        static {
            float theta = (float)class_3532.method_15349((double)0.5, (double)1.0);
            for (int i = 0; i < 5; ++i) {
                float phi = (float)i / 5.0f * ((float)Math.PI * 2);
                float x = class_3532.method_15362((float)theta) * class_3532.method_15362((float)phi);
                float y = class_3532.method_15374((float)theta);
                float z = class_3532.method_15362((float)theta) * class_3532.method_15374((float)phi);
                Icos.TOP_RING[i] = new float[]{x, y, z};
                Icos.BOTTOM_RING[i] = new float[]{-x, -y, -z};
            }
        }
    }
}

