/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.casting;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.spell.casting.SpellCircleContext;
import at.petrak.hexcasting.api.spell.mishaps.MishapEntityTooFarAway;
import at.petrak.hexcasting.api.spell.mishaps.MishapEvalTooDeep;
import at.petrak.hexcasting.api.spell.mishaps.MishapLocationTooFarAway;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\f\u0012\u0006\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\u0004\bW\u0010XB#\u0012\u0006\u0010\u0015\u001a\u00020\f\u0012\u0006\u0010\u0016\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\bW\u0010YJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\r\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J0\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\u000f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ3\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0!2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001b0\u001eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010'\u001a\u0004\u0018\u00010&2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0$\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010*\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0002\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010,\u001a\u00020&H\u00d6\u0001\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020\u0004\u00a2\u0006\u0004\b.\u0010/J\u0015\u00100\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b0\u0010+J\u0015\u00101\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b1\u0010+J\u0015\u00102\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b4\u00103J\u0015\u00105\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b5\u0010\u0006J\u0010\u00107\u001a\u000206H\u00d6\u0001\u00a2\u0006\u0004\b7\u00108J%\u0010=\u001a\u00020\u001b2\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020\u001b\u00a2\u0006\u0004\b=\u0010>R\u0011\u0010A\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0017\u0010\u0015\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010B\u001a\u0004\bC\u0010\u000eR\u0017\u0010\u0016\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010D\u001a\u0004\bE\u0010\u0011R\u0016\u0010F\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u001a\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00020H8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u0011\u0010K\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010@R\u0011\u0010M\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u0011R\u0011\u0010P\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010Q\u001a\u0004\bR\u0010\u0014R\u0011\u0010V\u001a\u00020S8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006Z"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "", "Lnet/minecraft/class_1297;", "entity", "", "assertEntityInRange", "(Lnet/minecraft/class_1297;)V", "Lnet/minecraft/class_243;", "vec", "assertVecInRange", "(Lnet/minecraft/class_243;)V", "assertVecInWorld", "Lnet/minecraft/class_3222;", "component1", "()Lnet/minecraft/class_3222;", "Lnet/minecraft/class_1268;", "component2", "()Lnet/minecraft/class_1268;", "Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;", "component3", "()Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;", "caster", "castingHand", "spellCircle", "copy", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1268;Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;)Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lkotlin/Function1;", "Lnet/minecraft/class_1799;", "acceptItemIf", "Lkotlin/Pair;", "getHeldItemToOperateOn", "(Lkotlin/jvm/functions/Function1;)Lkotlin/Pair;", "Ljava/util/function/Predicate;", "stackOK", "", "getOperativeSlot", "(Ljava/util/function/Predicate;)Ljava/lang/Integer;", "target", "hasBeenGivenMotion", "(Lnet/minecraft/class_1297;)Z", "hashCode", "()I", "incDepth", "()V", "isEntityInRange", "isEntityInWorld", "isVecInRange", "(Lnet/minecraft/class_243;)Z", "isVecInWorld", "markEntityAsMotionAdded", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_1792;", "item", "count", "actuallyRemove", "withdrawItem", "(Lnet/minecraft/class_1792;IZ)Z", "getCanOvercast", "()Z", "canOvercast", "Lnet/minecraft/class_3222;", "getCaster", "Lnet/minecraft/class_1268;", "getCastingHand", "depth", "I", "", "entitiesGivenMotion", "Ljava/util/Set;", "isCasterEnlightened", "getOtherHand", "otherHand", "getPosition", "()Lnet/minecraft/class_243;", "position", "Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;", "getSpellCircle", "Lnet/minecraft/class_3218;", "getWorld", "()Lnet/minecraft/class_3218;", "world", "<init>", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1268;)V", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1268;Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;)V", "hexcasting-fabric-1.18.2"})
public final class CastingContext {
    @NotNull
    private final class_3222 caster;
    @NotNull
    private final class_1268 castingHand;
    @Nullable
    private final SpellCircleContext spellCircle;
    private int depth;
    @NotNull
    private final Set<class_1297> entitiesGivenMotion;

    public CastingContext(@NotNull class_3222 caster, @NotNull class_1268 castingHand, @Nullable SpellCircleContext spellCircle) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)castingHand, (String)"castingHand");
        this.caster = caster;
        this.castingHand = castingHand;
        this.spellCircle = spellCircle;
        this.entitiesGivenMotion = new LinkedHashSet();
    }

    public /* synthetic */ CastingContext(class_3222 class_32222, class_1268 class_12682, SpellCircleContext spellCircleContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            spellCircleContext = null;
        }
        this(class_32222, class_12682, spellCircleContext);
    }

    @NotNull
    public final class_3222 getCaster() {
        return this.caster;
    }

    @NotNull
    public final class_1268 getCastingHand() {
        return this.castingHand;
    }

    @Nullable
    public final SpellCircleContext getSpellCircle() {
        return this.spellCircle;
    }

    public CastingContext(@NotNull class_3222 caster, @NotNull class_1268 castingHand) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)castingHand, (String)"castingHand");
        this(caster, castingHand, null);
    }

    @NotNull
    public final class_3218 getWorld() {
        class_3218 class_32182 = this.caster.method_14220();
        Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"caster.getLevel()");
        return class_32182;
    }

    @NotNull
    public final class_1268 getOtherHand() {
        return HexUtils.otherHand(this.castingHand);
    }

    @NotNull
    public final class_243 getPosition() {
        class_243 class_2432 = this.caster.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"caster.position()");
        return class_2432;
    }

    @NotNull
    public final Pair<class_1799, class_1268> getHeldItemToOperateOn(@NotNull Function1<? super class_1799, Boolean> acceptItemIf) {
        Intrinsics.checkNotNullParameter(acceptItemIf, (String)"acceptItemIf");
        boolean $i$f$getHeldItemToOperateOn = false;
        if (this.getSpellCircle() == null) {
            return TuplesKt.to((Object)this.getCaster().method_5998(this.getOtherHand()), (Object)this.getOtherHand());
        }
        class_1799 handItem = this.getCaster().method_5998(this.getCastingHand());
        Intrinsics.checkNotNullExpressionValue((Object)handItem, (String)"handItem");
        if (!((Boolean)acceptItemIf.invoke((Object)handItem)).booleanValue()) {
            return TuplesKt.to((Object)this.getCaster().method_5998(this.getOtherHand()), (Object)this.getOtherHand());
        }
        return TuplesKt.to((Object)handItem, (Object)this.getCastingHand());
    }

    public final void incDepth() {
        int n = this.depth;
        this.depth = n + 1;
        int maxAllowedDepth = HexConfig.server().maxRecurseDepth();
        if (this.depth > maxAllowedDepth) {
            throw new MishapEvalTooDeep();
        }
    }

    public final void assertVecInWorld(@NotNull class_243 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        if (!this.isVecInWorld(vec)) {
            throw new MishapLocationTooFarAway(vec, "out_of_world");
        }
    }

    public final void assertVecInRange(@NotNull class_243 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        if (!this.isVecInRange(vec)) {
            throw new MishapLocationTooFarAway(vec, null, 2, null);
        }
        this.assertVecInWorld(vec);
    }

    public final void assertEntityInRange(@NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(entity instanceof class_1657) && !this.isEntityInRange(entity)) {
            throw new MishapEntityTooFarAway(entity);
        }
    }

    public final boolean hasBeenGivenMotion(@NotNull class_1297 target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.entitiesGivenMotion.contains(target);
    }

    public final boolean isVecInWorld(@NotNull class_243 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return this.getWorld().method_24794(new class_2338(vec)) && this.getWorld().method_8621().method_35317(vec.field_1352, vec.field_1350);
    }

    public final boolean isVecInRange(@NotNull class_243 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Sentinel sentinel = IXplatAbstractions.INSTANCE.getSentinel((class_1657)this.caster);
        if (sentinel.hasSentinel() && sentinel.extendsRange() && Intrinsics.areEqual((Object)this.getWorld().method_27983(), sentinel.dimension()) && vec.method_1025(sentinel.position()) < 256.0) {
            return true;
        }
        if (this.spellCircle != null) {
            if (this.spellCircle.getActivatorAlwaysInRange() && vec.method_1025(this.caster.method_33571()) < 4.0) {
                return true;
            }
            return this.spellCircle.getAabb().method_1006(vec);
        }
        return vec.method_1025(this.caster.method_19538()) < 1024.0;
    }

    public final boolean isEntityInWorld(@NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        class_243 class_2432 = entity.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"entity.position()");
        return this.isVecInWorld(class_2432);
    }

    public final boolean isEntityInRange(@NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.spellCircle != null && this.spellCircle.getActivatorAlwaysInRange() && Intrinsics.areEqual((Object)this.caster, (Object)entity)) {
            return true;
        }
        class_243 class_2432 = entity.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"entity.position()");
        return this.isVecInRange(class_2432);
    }

    @Nullable
    public final Integer getOperativeSlot(@NotNull Predicate<class_1799> stackOK) {
        Intrinsics.checkNotNullParameter(stackOK, (String)"stackOK");
        class_1799 otherHandStack = this.caster.method_5998(this.getOtherHand());
        if (stackOK.test(otherHandStack)) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.getOtherHand().ordinal()]) {
                case 1 -> this.caster.method_31548().field_7545;
                case 2 -> 150;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        int anchorSlot = switch (WhenMappings.$EnumSwitchMapping$0[this.castingHand.ordinal()]) {
            case 1 -> (this.caster.method_31548().field_7545 + 1) % 9;
            case 2 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        };
        for (int delta = 0; delta < 9; ++delta) {
            int slot = (anchorSlot + delta) % 9;
            class_1799 stack = this.caster.method_31548().method_5438(slot);
            if (!stackOK.test(stack)) continue;
            return slot;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean withdrawItem(@NotNull class_1792 item, int count, boolean actuallyRemove) {
        void $this$fold$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.caster.method_7337()) {
            return true;
        }
        class_1661 inv = this.caster.method_31548();
        class_2371 class_23712 = inv.field_7547;
        Intrinsics.checkNotNullExpressionValue((Object)class_23712, (String)"inv.items");
        Iterable $this$withdrawItem_u24lambda_u2d0 = list = CollectionsKt.toMutableList((Collection)((Collection)class_23712));
        boolean bl = false;
        $this$withdrawItem_u24lambda_u2d0.remove(inv.field_7545);
        List stacksToExamine = CollectionsKt.toMutableList((Collection)CollectionsKt.asReversedMutable((List)list));
        class_2371 class_23713 = inv.field_7544;
        Intrinsics.checkNotNullExpressionValue((Object)class_23713, (String)"inv.offhand");
        stacksToExamine.addAll((Collection)class_23713);
        stacksToExamine.add(inv.method_7391());
        $this$withdrawItem_u24lambda_u2d0 = stacksToExamine;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void stack;
            class_1799 class_17992 = (class_1799)element$iv;
            int acc = accumulator$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            accumulator$iv = acc + (CastingContext.withdrawItem$matches(item, (class_1799)stack) ? stack.method_7947() : 0);
        }
        int presentCount = accumulator$iv;
        if (presentCount < count) {
            return false;
        }
        if (!actuallyRemove) {
            return true;
        }
        int remaining = count;
        for (class_1799 stack : stacksToExamine) {
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            if (!CastingContext.withdrawItem$matches(item, stack)) continue;
            int toWithdraw = Math.min(stack.method_7947(), remaining);
            stack.method_7934(toWithdraw);
            if ((remaining -= toWithdraw) > 0) continue;
            return true;
        }
        throw new RuntimeException("unreachable");
    }

    public final void markEntityAsMotionAdded(@NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entitiesGivenMotion.add(entity);
    }

    public final boolean getCanOvercast() {
        class_161 adv = this.getWorld().method_8503().method_3851().method_12896(HexAPI.modLoc("y_u_no_cast_angy"));
        class_2985 advs = this.caster.method_14236();
        class_161 class_1612 = adv;
        Intrinsics.checkNotNull((Object)class_1612);
        return advs.method_12882(class_1612).method_740();
    }

    public final boolean isCasterEnlightened() {
        class_161 adv = this.getWorld().method_8503().method_3851().method_12896(HexAPI.modLoc("enlightenment"));
        class_2985 advs = this.caster.method_14236();
        class_161 class_1612 = adv;
        Intrinsics.checkNotNull((Object)class_1612);
        return advs.method_12882(class_1612).method_740();
    }

    @NotNull
    public final class_3222 component1() {
        return this.caster;
    }

    @NotNull
    public final class_1268 component2() {
        return this.castingHand;
    }

    @Nullable
    public final SpellCircleContext component3() {
        return this.spellCircle;
    }

    @NotNull
    public final CastingContext copy(@NotNull class_3222 caster, @NotNull class_1268 castingHand, @Nullable SpellCircleContext spellCircle) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)castingHand, (String)"castingHand");
        return new CastingContext(caster, castingHand, spellCircle);
    }

    public static /* synthetic */ CastingContext copy$default(CastingContext castingContext, class_3222 class_32222, class_1268 class_12682, SpellCircleContext spellCircleContext, int n, Object object) {
        if ((n & 1) != 0) {
            class_32222 = castingContext.caster;
        }
        if ((n & 2) != 0) {
            class_12682 = castingContext.castingHand;
        }
        if ((n & 4) != 0) {
            spellCircleContext = castingContext.spellCircle;
        }
        return castingContext.copy(class_32222, class_12682, spellCircleContext);
    }

    @NotNull
    public String toString() {
        return "CastingContext(caster=" + this.caster + ", castingHand=" + this.castingHand + ", spellCircle=" + this.spellCircle + ")";
    }

    public int hashCode() {
        int result = this.caster.hashCode();
        result = result * 31 + this.castingHand.hashCode();
        result = result * 31 + (this.spellCircle == null ? 0 : this.spellCircle.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CastingContext)) {
            return false;
        }
        CastingContext castingContext = (CastingContext)other;
        if (!Intrinsics.areEqual((Object)this.caster, (Object)castingContext.caster)) {
            return false;
        }
        if (this.castingHand != castingContext.castingHand) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.spellCircle, (Object)castingContext.spellCircle);
    }

    private static final boolean withdrawItem$matches(class_1792 $item, class_1799 stack) {
        return !stack.method_7960() && stack.method_31574($item);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[class_1268.values().length];
            nArray[class_1268.field_5808.ordinal()] = 1;
            nArray[class_1268.field_5810.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

