/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell;

import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.Operator;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.OperatorSideEffect;
import at.petrak.hexcasting.api.spell.casting.SpellContinuation;
import at.petrak.hexcasting.api.spell.mishaps.MishapNotEnoughArgs;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006JC\u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0007\u0018\u00010\n2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0006J=\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00132\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\f8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lat/petrak/hexcasting/api/spell/SpellOperator;", "Lat/petrak/hexcasting/api/spell/Operator;", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "ctx", "", "awardsCastingStat", "(Lat/petrak/hexcasting/api/spell/casting/CastingContext;)Z", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "args", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/spell/casting/CastingContext;)Lkotlin/Triple;", "hasCastingSound", "Lat/petrak/hexcasting/api/spell/casting/SpellContinuation;", "continuation", "", "stack", "local", "Lat/petrak/hexcasting/api/spell/OperationResult;", "operate", "(Lat/petrak/hexcasting/api/spell/casting/SpellContinuation;Ljava/util/List;Lat/petrak/hexcasting/api/spell/SpellDatum;Lat/petrak/hexcasting/api/spell/casting/CastingContext;)Lat/petrak/hexcasting/api/spell/OperationResult;", "getArgc", "()I", "argc", "hexcasting-fabric-1.18.2"})
public interface SpellOperator
extends Operator {
    public int getArgc();

    public boolean hasCastingSound(@NotNull CastingContext var1);

    public boolean awardsCastingStat(@NotNull CastingContext var1);

    @Nullable
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends SpellDatum<?>> var1, @NotNull CastingContext var2);

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation var1, @NotNull List<SpellDatum<?>> var2, @NotNull SpellDatum<?> var3, @NotNull CastingContext var4);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean hasCastingSound(@NotNull SpellOperator this_, @NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return true;
        }

        public static boolean awardsCastingStat(@NotNull SpellOperator this_, @NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return true;
        }

        @NotNull
        public static OperationResult operate(@NotNull SpellOperator this_, @NotNull SpellContinuation continuation, @NotNull List<SpellDatum<?>> stack, @NotNull SpellDatum<?> local, @NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
            Intrinsics.checkNotNullParameter(stack, (String)"stack");
            Intrinsics.checkNotNullParameter(local, (String)"local");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this_.getArgc() > stack.size()) {
                throw new MishapNotEnoughArgs(this_.getArgc(), stack.size());
            }
            List args = CollectionsKt.takeLast(stack, (int)this_.getArgc());
            int n = this_.getArgc();
            for (int _i = 0; _i < n; ++_i) {
                CollectionsKt.removeLast(stack);
            }
            Triple<RenderedSpell, Integer, List<ParticleSpray>> triple = this_.execute(args, ctx);
            if (triple == null) {
                return new OperationResult(continuation, stack, local, CollectionsKt.emptyList());
            }
            Triple<RenderedSpell, Integer, List<ParticleSpray>> executeResult = triple;
            RenderedSpell spell = (RenderedSpell)executeResult.component1();
            int mana = ((Number)executeResult.component2()).intValue();
            List particles = (List)executeResult.component3();
            List sideEffects = new ArrayList();
            if (mana > 0) {
                sideEffects.add(new OperatorSideEffect.ConsumeMana(mana));
            }
            if (!this_.isGreat() || ctx.isCasterEnlightened()) {
                sideEffects.add(new OperatorSideEffect.AttemptSpell(spell, this_.hasCastingSound(ctx), this_.awardsCastingStat(ctx)));
            }
            for (ParticleSpray spray : particles) {
                sideEffects.add(new OperatorSideEffect.Particles(spray));
            }
            return new OperationResult(continuation, stack, local, sideEffects);
        }

        public static boolean isGreat(@NotNull SpellOperator this_) {
            return Operator.DefaultImpls.isGreat(this_);
        }

        public static boolean getAlwaysProcessGreatSpell(@NotNull SpellOperator this_) {
            return Operator.DefaultImpls.getAlwaysProcessGreatSpell(this_);
        }

        public static boolean getCausesBlindDiversion(@NotNull SpellOperator this_) {
            return Operator.DefaultImpls.getCausesBlindDiversion(this_);
        }
    }
}

