/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.misc;

import at.petrak.hexcasting.api.addldata.Colorizer;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5253;

public record FrozenColorizer(class_1799 item, UUID owner) {
    private static final int[] MINIMUM_LUMINANCE_COLOR_WHEEL = new int[]{-14680064, -14671872, -16769024, -16768992, -16777184, -14680032};
    public static final String TAG_STACK = "stack";
    public static final String TAG_OWNER = "owner";
    public static final Supplier<FrozenColorizer> DEFAULT = () -> new FrozenColorizer(new class_1799((class_1935)HexItems.DYE_COLORIZERS.get(class_1767.field_7952)), class_156.field_25140);

    public class_2487 serializeToNBT() {
        class_2487 out = new class_2487();
        out.method_10566(TAG_STACK, (class_2520)HexUtils.serializeToNBT(this.item));
        out.method_25927(TAG_OWNER, this.owner);
        return out;
    }

    public static FrozenColorizer fromNBT(class_2487 tag) {
        if (tag.method_33133()) {
            return DEFAULT.get();
        }
        try {
            class_1799 stack = class_1799.method_7915((class_2487)tag.method_10562(TAG_STACK));
            UUID uuid = tag.method_25926(TAG_OWNER);
            return new FrozenColorizer(stack, uuid);
        }
        catch (NullPointerException exn) {
            return DEFAULT.get();
        }
    }

    public int getColor(float time, class_243 position) {
        int b;
        int g;
        int raw = IXplatAbstractions.INSTANCE.getRawColor(this, time, position);
        int r = class_5253.class_5254.method_27765((int)raw);
        double luminance = (0.2126 * (double)r + 0.7152 * (double)(g = class_5253.class_5254.method_27766((int)raw)) + 0.0722 * (double)(b = class_5253.class_5254.method_27767((int)raw))) / 255.0;
        if (luminance < 0.05) {
            int rawMod = Colorizer.morphBetweenColors(MINIMUM_LUMINANCE_COLOR_WHEEL, new class_243(0.1, 0.1, 0.1), time / 20.0f / 20.0f, position);
            r += class_5253.class_5254.method_27765((int)rawMod);
            g += class_5253.class_5254.method_27766((int)rawMod);
            b += class_5253.class_5254.method_27767((int)rawMod);
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

