/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.client;

import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScryingLensOverlayRegistry {
    private static final ConcurrentMap<class_2960, OverlayBuilder> ID_LOOKUP = new ConcurrentHashMap<class_2960, OverlayBuilder>();
    private static final List<Pair<OverlayPredicate, OverlayBuilder>> PREDICATE_LOOKUP = new Vector<Pair<OverlayPredicate, OverlayBuilder>>();
    private static final Map<class_746, Pair<class_2338, Integer>> comparatorData = new WeakHashMap<class_746, Pair<class_2338, Integer>>();

    public static void receiveComparatorValue(class_2338 pos, int value) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            if (pos == null || value == -1) {
                comparatorData.remove(player);
            } else {
                comparatorData.put(player, (Pair<class_2338, Integer>)new Pair((Object)pos, (Object)value));
            }
        }
    }

    public static int getComparatorValue(boolean onlyRealComparators) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;
        class_239 result = mc.field_1765;
        if (player == null || level == null || result == null || result.method_17783() != class_239.class_240.field_1332) {
            return -1;
        }
        Pair<class_2338, Integer> comparatorValue = comparatorData.get(player);
        if (comparatorValue == null) {
            return -1;
        }
        class_2338 pos = ((class_3965)result).method_17777();
        if (!pos.equals(comparatorValue.getFirst())) {
            return -1;
        }
        class_2680 state = mc.field_1687.method_8320(pos);
        if (onlyRealComparators && !state.method_27852(class_2246.field_10377) || !onlyRealComparators && !state.method_26221()) {
            return -1;
        }
        return (Integer)comparatorValue.getSecond();
    }

    public static void addDisplayer(class_2248 block, OverlayBuilder displayer) {
        ScryingLensOverlayRegistry.addDisplayer(IXplatAbstractions.INSTANCE.getID(block), displayer);
    }

    public static void addDisplayer(class_2960 blockID, OverlayBuilder displayer) {
        if (ID_LOOKUP.containsKey(blockID)) {
            throw new IllegalArgumentException("Already have a displayer for " + blockID);
        }
        ID_LOOKUP.put(blockID, displayer);
    }

    public static void addPredicateDisplayer(OverlayPredicate predicate, OverlayBuilder displayer) {
        PREDICATE_LOOKUP.add((Pair<OverlayPredicate, OverlayBuilder>)new Pair((Object)predicate, (Object)displayer));
    }

    @NotNull
    public static List<Pair<class_1799, class_2561>> getLines(class_2680 state, class_2338 pos, class_746 observer, class_638 world, class_2350 hitFace, @Nullable class_1268 lensHand) {
        ArrayList lines = Lists.newArrayList();
        OverlayBuilder idLookedup = (OverlayBuilder)ID_LOOKUP.get(IXplatAbstractions.INSTANCE.getID(state.method_26204()));
        if (idLookedup != null) {
            idLookedup.addLines(lines, state, pos, observer, world, hitFace, lensHand);
        }
        for (Pair<OverlayPredicate, OverlayBuilder> pair : PREDICATE_LOOKUP) {
            if (!((OverlayPredicate)pair.getFirst()).test(state, pos, observer, world, hitFace, lensHand)) continue;
            ((OverlayBuilder)pair.getSecond()).addLines(lines, state, pos, observer, world, hitFace, lensHand);
        }
        return lines;
    }

    @FunctionalInterface
    public static interface OverlayBuilder {
        public void addLines(List<Pair<class_1799, class_2561>> var1, class_2680 var2, class_2338 var3, class_746 var4, class_638 var5, class_2350 var6, @Nullable class_1268 var7);
    }

    @FunctionalInterface
    public static interface OverlayPredicate {
        public boolean test(class_2680 var1, class_2338 var2, class_746 var3, class_638 var4, class_2350 var5, @Nullable class_1268 var6);
    }
}

