/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.block.circle;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.SpellCircleContext;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityAbstractImpetus
extends HexBlockEntity
implements class_1278 {
    public static final String TAG_ACTIVATOR = "activator";
    public static final String TAG_COLORIZER = "colorizer";
    public static final String TAG_NEXT_BLOCK = "next_block";
    public static final String TAG_TRACKED_BLOCKS = "tracked_blocks";
    public static final String TAG_FOUND_ALL = "found_all";
    public static final String TAG_MANA = "mana";
    public static final String TAG_LAST_MISHAP = "last_mishap";
    @Nullable
    private UUID activator = null;
    @Nullable
    private FrozenColorizer colorizer = null;
    @Nullable
    private class_2338 nextBlock = null;
    @Nullable
    private List<class_2338> trackedBlocks = null;
    private transient Set<class_2338> knownBlocks = null;
    private boolean foundAll = false;
    @Nullable
    private class_2561 lastMishap = null;
    private int mana = 0;
    private static final int[] MAJOR_SCALE = new int[]{0, 2, 4, 5, 7, 9, 11, 12};
    private static final int[] MINOR_SCALE = new int[]{0, 2, 3, 5, 7, 8, 11, 12};
    private static final int[] DORIAN_SCALE = new int[]{0, 2, 3, 5, 7, 9, 10, 12};
    private static final int[] MIXOLYDIAN_SCALE = new int[]{0, 2, 4, 5, 7, 9, 10, 12};
    private static final int[] BLUES_SCALE = new int[]{0, 3, 5, 6, 7, 10, 12};
    private static final int[] BAD_TIME = new int[]{0, 0, 12, 7, 6, 5, 3, 0, 3, 5};
    private static final int[] SUSSY_BAKA = new int[]{5, 8, 10, 11, 10, 8, 5, 3, 7, 5};
    private static final int[] SLOTS = new int[]{0};

    public BlockEntityAbstractImpetus(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public abstract boolean activatorAlwaysInRange();

    public int getMana() {
        return this.mana;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Nullable
    public class_2561 getLastMishap() {
        return this.lastMishap;
    }

    public void setLastMishap(@Nullable class_2561 lastMishap) {
        this.lastMishap = lastMishap;
    }

    public void activateSpellCircle(class_3222 activator) {
        if (this.nextBlock != null) {
            return;
        }
        this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), this.getTickSpeed());
        this.activator = activator.method_5667();
        this.nextBlock = this.method_11016();
        this.trackedBlocks = new ArrayList<class_2338>();
        this.knownBlocks = new HashSet<class_2338>();
        this.colorizer = IXplatAbstractions.INSTANCE.getColorizer((class_1657)activator);
        this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)BlockAbstractImpetus.ENERGIZED, (Comparable)Boolean.valueOf(true)));
        this.stepCircle();
    }

    public void applyScryingLensOverlay(List<Pair<class_1799, class_2561>> lines, class_2680 state, class_2338 pos, class_746 observer, class_638 world, class_2350 hitFace, class_1268 lensHand) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)class_25862;
            float dustCount = (float)beai.getMana() / 10000.0f;
            class_2588 dustCmp = new class_2588("hexcasting.tooltip.lens.impetus.mana", new Object[]{String.format("%.2f", Float.valueOf(dustCount))});
            lines.add((Pair<class_1799, class_2561>)new Pair((Object)new class_1799((class_1935)HexItems.AMETHYST_DUST), (Object)dustCmp));
            class_2561 mishap = this.getLastMishap();
            if (mishap != null) {
                lines.add((Pair<class_1799, class_2561>)new Pair((Object)new class_1799((class_1935)class_1802.field_8731), (Object)mishap));
            }
        }
    }

    @Override
    protected void saveModData(class_2487 tag) {
        if (this.activator != null && this.colorizer != null && this.nextBlock != null && this.trackedBlocks != null) {
            tag.method_25927(TAG_ACTIVATOR, this.activator);
            tag.method_10566(TAG_NEXT_BLOCK, (class_2520)class_2512.method_10692((class_2338)this.nextBlock));
            tag.method_10566(TAG_COLORIZER, (class_2520)this.colorizer.serializeToNBT());
            tag.method_10556(TAG_FOUND_ALL, this.foundAll);
            class_2499 trackeds = new class_2499();
            for (class_2338 tracked : this.trackedBlocks) {
                trackeds.add((Object)class_2512.method_10692((class_2338)tracked));
            }
            tag.method_10566(TAG_TRACKED_BLOCKS, (class_2520)trackeds);
        }
        tag.method_10569(TAG_MANA, this.mana);
        if (this.lastMishap != null) {
            tag.method_10582(TAG_LAST_MISHAP, class_2561.class_2562.method_10867((class_2561)this.lastMishap));
        }
    }

    @Override
    protected void loadModData(class_2487 tag) {
        if (tag.method_10573(TAG_ACTIVATOR, 11) && tag.method_10573(TAG_COLORIZER, 10) && tag.method_10573(TAG_NEXT_BLOCK, 10) && tag.method_10573(TAG_TRACKED_BLOCKS, 9)) {
            this.activator = tag.method_25926(TAG_ACTIVATOR);
            this.colorizer = FrozenColorizer.fromNBT(tag.method_10562(TAG_COLORIZER));
            this.nextBlock = class_2512.method_10691((class_2487)tag.method_10562(TAG_NEXT_BLOCK));
            this.foundAll = tag.method_10577(TAG_FOUND_ALL);
            class_2499 trackeds = tag.method_10554(TAG_TRACKED_BLOCKS, 10);
            this.trackedBlocks = new ArrayList<class_2338>(trackeds.size());
            this.knownBlocks = new HashSet<class_2338>();
            for (class_2520 tracked : trackeds) {
                class_2338 pos = class_2512.method_10691((class_2487)((class_2487)tracked));
                this.trackedBlocks.add(pos);
                this.knownBlocks.add(pos);
            }
        } else {
            this.activator = null;
            this.colorizer = null;
            this.nextBlock = null;
            this.foundAll = false;
            this.trackedBlocks = new ArrayList<class_2338>();
            this.knownBlocks = new HashSet<class_2338>();
        }
        this.mana = tag.method_10550(TAG_MANA);
        this.lastMishap = tag.method_10573(TAG_LAST_MISHAP, 8) ? class_2561.class_2562.method_10877((String)tag.method_10558(TAG_LAST_MISHAP)) : null;
    }

    void stepCircle() {
        this.method_5431();
        if (this.activator == null || this.colorizer == null || this.nextBlock == null || this.trackedBlocks == null) {
            return;
        }
        class_2338 possibleErrorPos = this.checkEverythingOk();
        if (possibleErrorPos != null) {
            this.sfx(possibleErrorPos, false);
            this.stopCasting();
            return;
        }
        if (this.foundAll) {
            this.clearEnergized();
            this.castSpell();
            this.stopCasting();
            return;
        }
        class_2680 bsHere = this.field_11863.method_8320(this.nextBlock);
        if (!this.trackedBlocks.isEmpty() && bsHere.method_26204() instanceof BlockAbstractImpetus) {
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        class_2248 blockHere = bsHere.method_26204();
        if (!(blockHere instanceof BlockCircleComponent)) {
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        BlockCircleComponent cc = (BlockCircleComponent)blockHere;
        class_2350 thisNormal = cc.normalDir(this.nextBlock, bsHere, this.field_11863);
        EnumSet<class_2350> possibleExits = cc.exitDirections(this.nextBlock, bsHere, this.field_11863);
        class_2338 foundPos = null;
        for (class_2350 exit : possibleExits) {
            BlockCircleComponent cc2;
            class_2248 class_22482;
            class_2338 neighborPos = this.nextBlock.method_10093(exit);
            class_2680 blockThere = this.field_11863.method_8320(neighborPos);
            boolean closedLoop = this.trackedBlocks.size() >= 3 && this.trackedBlocks.get(0).equals((Object)neighborPos);
            boolean mightBeOkThere = closedLoop || this.trackedBlocks.isEmpty() || !this.trackedBlocks.get(this.trackedBlocks.size() - 1).equals((Object)neighborPos);
            if (!mightBeOkThere || !((class_22482 = blockThere.method_26204()) instanceof BlockCircleComponent) || !(cc2 = (BlockCircleComponent)class_22482).canEnterFromDirection(exit.method_10153(), thisNormal, neighborPos, blockThere, this.field_11863) || ((Boolean)blockThere.method_11654((class_2769)BlockCircleComponent.ENERGIZED)).booleanValue() && !this.knownBlocks.contains(neighborPos)) continue;
            if (foundPos == null) {
                foundPos = neighborPos;
                this.foundAll |= closedLoop;
                continue;
            }
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        if (foundPos == null) {
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        this.trackedBlocks.add(this.nextBlock);
        this.knownBlocks.add(this.nextBlock);
        this.nextBlock = foundPos;
        class_2338 lastPos = this.trackedBlocks.get(this.trackedBlocks.size() - 1);
        class_2680 justTrackedBlock = this.field_11863.method_8320(lastPos);
        this.field_11863.method_8501(lastPos, (class_2680)justTrackedBlock.method_11657((class_2769)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(true)));
        this.sfx(lastPos, true);
        this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), this.getTickSpeed());
    }

    private void castSpell() {
        class_1657 player = this.getPlayer();
        if (player instanceof class_3222) {
            class_3222 splayer = (class_3222)player;
            class_238 bounds = BlockEntityAbstractImpetus.getBounds(this.trackedBlocks);
            CastingContext ctx = new CastingContext(splayer, class_1268.field_5808, new SpellCircleContext(this.method_11016(), bounds, this.activatorAlwaysInRange()));
            CastingHarness harness = new CastingHarness(ctx);
            boolean makeSound = false;
            class_2338 erroredPos = null;
            for (class_2338 tracked : this.trackedBlocks) {
                BlockCircleComponent cc;
                HexPattern newPattern;
                class_2680 bs = this.field_11863.method_8320(tracked);
                class_2248 class_22482 = bs.method_26204();
                if (!(class_22482 instanceof BlockCircleComponent) || (newPattern = (cc = (BlockCircleComponent)class_22482).getPattern(tracked, bs, this.field_11863)) == null) continue;
                ControllerInfo info = harness.executeIota(SpellDatum.make(newPattern), splayer.method_14220());
                if (info.getMakesCastSound()) {
                    makeSound = true;
                }
                if (info.getResolutionType().getSuccess()) continue;
                erroredPos = tracked;
                break;
            }
            if (makeSound) {
                this.field_11863.method_8396(null, this.method_11016(), HexSounds.SPELL_CIRCLE_CAST, class_3419.field_15245, 2.0f, 1.0f);
            }
            if (erroredPos != null) {
                this.sfx(erroredPos, false);
            } else {
                this.setLastMishap(null);
            }
            this.method_5431();
        }
    }

    @Contract(pure=true)
    private static class_238 getBounds(List<class_2338> poses) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : poses) {
            if (pos.method_10263() < minX) {
                minX = pos.method_10263();
            }
            if (pos.method_10264() < minY) {
                minY = pos.method_10264();
            }
            if (pos.method_10260() < minZ) {
                minZ = pos.method_10260();
            }
            if (pos.method_10263() > maxX) {
                maxX = pos.method_10263();
            }
            if (pos.method_10264() > maxY) {
                maxY = pos.method_10264();
            }
            if (pos.method_10260() <= maxZ) continue;
            maxZ = pos.method_10260();
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    @Nullable
    private class_2338 checkEverythingOk() {
        if (this.getPlayer() == null) {
            return this.method_11016();
        }
        for (class_2338 pos : this.trackedBlocks) {
            if (this.field_11863.method_8320(pos).method_26204() instanceof BlockCircleComponent) continue;
            return pos;
        }
        if (this.trackedBlocks.size() > HexConfig.server().maxSpellCircleLength()) {
            return this.trackedBlocks.get(this.trackedBlocks.size() - 1);
        }
        return null;
    }

    private void sfx(class_2338 pos, boolean success) {
        class_243 vpos;
        class_243 vecOutDir;
        class_2350 outDir;
        class_2680 bs = this.field_11863.method_8320(pos);
        class_2248 class_22482 = bs.method_26204();
        if (class_22482 instanceof BlockCircleComponent) {
            BlockCircleComponent bcc = (BlockCircleComponent)class_22482;
            outDir = bcc.normalDir(pos, bs, this.field_11863);
            float height = bcc.particleHeight(pos, bs, this.field_11863);
            vecOutDir = new class_243(outDir.method_23955());
            vpos = class_243.method_24953((class_2382)pos).method_1019(vecOutDir.method_1021((double)height));
        } else {
            vpos = class_243.method_24953((class_2382)pos);
            vecOutDir = new class_243(0.0, 0.0, 0.0);
        }
        outDir = this.field_11863;
        if (outDir instanceof class_3218) {
            class_3218 serverLevel = (class_3218)outDir;
            ParticleSpray spray = new ParticleSpray(vpos, vecOutDir.method_1021(success ? 1.0 : 1.5), success ? 0.1 : 0.5, (float)Math.PI / (float)(success ? 4 : 2), success ? 30 : 100);
            spray.sprayParticles(serverLevel, success ? this.colorizer : new FrozenColorizer(new class_1799((class_1935)HexItems.DYE_COLORIZERS.get(class_1767.field_7964)), this.activator));
        }
        float pitch = 1.0f;
        class_3414 sound = HexSounds.SPELL_CIRCLE_FAIL;
        if (success) {
            sound = HexSounds.SPELL_CIRCLE_FIND_BLOCK;
            int note = this.trackedBlocks.size() - 1;
            int semitone = this.semitoneFromScale(note);
            pitch = (float)Math.pow(2.0, (double)(semitone - 8) / 12.0);
        }
        this.field_11863.method_8465(null, vpos.field_1352, vpos.field_1351, vpos.field_1350, sound, class_3419.field_15245, 1.0f, pitch);
    }

    protected void clearEnergized() {
        if (this.trackedBlocks != null) {
            for (class_2338 tracked : this.trackedBlocks) {
                class_2680 bs = this.field_11863.method_8320(tracked);
                if (!(bs.method_26204() instanceof BlockCircleComponent)) continue;
                this.field_11863.method_8501(tracked, (class_2680)bs.method_11657((class_2769)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected void stopCasting() {
        this.clearEnergized();
        this.activator = null;
        this.nextBlock = null;
        this.trackedBlocks = null;
        this.foundAll = false;
        if (this.field_11863.method_8320(this.method_11016()).method_26204() instanceof BlockAbstractImpetus) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nullable
    protected class_1657 getPlayer() {
        return this.field_11863.method_18470(this.activator);
    }

    protected int getTickSpeed() {
        if (this.trackedBlocks == null) {
            return 10;
        }
        return Math.max(2, 10 - this.trackedBlocks.size() / 3);
    }

    protected int semitoneFromScale(int note) {
        class_2680 blockBelow = this.field_11863.method_8320(this.method_11016().method_10074());
        int[] scale = MAJOR_SCALE;
        if (blockBelow.method_27852(class_2246.field_22423)) {
            scale = MINOR_SCALE;
        } else if (blockBelow.method_26164(class_3481.field_15495) || blockBelow.method_26164(class_3481.field_15487)) {
            scale = DORIAN_SCALE;
        } else if (blockBelow.method_27852(class_2246.field_10560) || blockBelow.method_27852(class_2246.field_10615)) {
            scale = MIXOLYDIAN_SCALE;
        } else if (blockBelow.method_27852(class_2246.field_10514) || blockBelow.method_27852(class_2246.field_10011) || blockBelow.method_27852(class_2246.field_10456) || blockBelow.method_27852(class_2246.field_10409) || blockBelow.method_27852(class_2246.field_10550) || blockBelow.method_27852(class_2246.field_10060) || blockBelow.method_27852(class_2246.field_9982)) {
            scale = BLUES_SCALE;
        } else if (blockBelow.method_27852(class_2246.field_10166)) {
            scale = BAD_TIME;
        } else if (blockBelow.method_27852(class_2246.field_17563)) {
            scale = SUSSY_BAKA;
        }
        note = class_3532.method_15340((int)note, (int)0, (int)(scale.length - 1));
        return scale[note];
    }

    public int[] method_5494(class_2350 var1) {
        return SLOTS;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int var1, class_1799 var2, class_2350 var3) {
        return false;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return true;
    }

    public class_1799 method_5438(int index) {
        return class_1799.field_8037.method_7972();
    }

    public class_1799 method_5434(int index, int count) {
        return class_1799.field_8037.method_7972();
    }

    public class_1799 method_5441(int index) {
        return class_1799.field_8037.method_7972();
    }

    public void method_5447(int index, class_1799 stack) {
        int manamount = ManaHelper.extractMana(stack, -1, true, false);
        if (manamount > 0) {
            this.mana += manamount;
            this.sync();
        }
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public boolean method_5437(int index, class_1799 stack) {
        int manamount = ManaHelper.extractMana(stack, -1, true, true);
        return manamount > 0;
    }

    public void method_5448() {
        this.mana = 0;
        this.stopCasting();
        this.sync();
    }
}

