package at.petrak.hexcasting.xplat;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.addldata.HexHolder;
import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import at.petrak.hexcasting.common.network.IMessage;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_5341;

/**
 * more like IHexplatAbstracts lmaooooooo
 */
public interface IXplatAbstractions {
    Platform platform();

    boolean isModPresent(String id);

    boolean isPhysicalClient();

    void initPlatformSpecific();

    void sendPacketToPlayer(class_3222 target, IMessage packet);

    void sendPacketNear(class_243 pos, double radius, class_3218 dimension, IMessage packet);

    // https://github.com/VazkiiMods/Botania/blob/13b7bcd9cbb6b1a418b0afe455662d29b46f1a7f/Xplat/src/main/java/vazkii/botania/xplat/IXplatAbstractions.java#L157
    class_2596<?> toVanillaClientboundPacket(IMessage message);

    class_1320 getReachDistance();

    // Things that used to be caps

    /**
     * Irregardless of whether it can actually be brainswept (you need to do the checking yourself)
     */
    void brainsweep(class_1308 mob);

    void setColorizer(class_1657 target, FrozenColorizer colorizer);

    void setSentinel(class_1657 target, Sentinel sentinel);

    void setFlight(class_3222 target, FlightAbility flight);

    void setHarness(class_3222 target, @Nullable CastingHarness harness);

    void setPatterns(class_3222 target, List<ResolvedPattern> patterns);

    boolean isBrainswept(class_1308 mob);

    FlightAbility getFlight(class_3222 player);

    FrozenColorizer getColorizer(class_1657 player);

    Sentinel getSentinel(class_1657 player);

    CastingHarness getHarness(class_3222 player, class_1268 hand);

    List<ResolvedPattern> getPatterns(class_3222 player);

    void clearCastingData(class_3222 player);

    @Nullable
    ManaHolder findManaHolder(class_1799 stack);

    @Nullable
    DataHolder findDataHolder(class_1799 stack);

    @Nullable
    HexHolder findHexHolder(class_1799 stack);

    // coooollooorrrs

    boolean isColorizer(class_1799 stack);

    int getRawColor(FrozenColorizer colorizer, float time, class_243 position);

    // Items

    /**
     * No-op on forge (use a SoftImplement)
     */
    class_1792.class_1793 addEquipSlotFabric(class_1304 slot);

    // Blocks

    <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> func,
        class_2248... blocks);

    boolean tryPlaceFluid(class_1937 level, class_1268 hand, class_2338 pos, class_1799 stack, class_3611 fluid);


    // misc

    class_1761 getTab();

    boolean isCorrectTierForDrops(class_1832 tier, class_2680 bs);

    class_2960 getID(class_2248 block);

    class_2960 getID(class_1792 item);

    class_2960 getID(class_3852 profession);

    class_1856 getUnsealedIngredient(class_1799 stack);

    IXplatTags tags();

    class_5341.class_210 isShearsCondition();

    ///

    IXplatAbstractions INSTANCE = find();

    private static IXplatAbstractions find() {
        var providers = ServiceLoader.load(IXplatAbstractions.class).stream().toList();
        if (providers.size() != 1) {
            var names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException(
                "There should be exactly one IXplatAbstractions implementation on the classpath. Found: " + names);
        } else {
            var provider = providers.get(0);
            HexAPI.LOGGER.debug("Instantiating xplat impl: " + provider.type().getName());
            return provider.get();
        }
    }

}
