package at.petrak.hexcasting.xplat;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.network.IMessage;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1800;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_4002;
import net.minecraft.class_5617;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_707;
import var;

public interface IClientXplatAbstractions {
    void sendPacketToServer(IMessage packet);

    void setRenderLayer(class_2248 block, class_1921 type);

    <T extends class_1297> void registerEntityRenderer(class_1299<? extends T> type, class_5617<T> renderer);

    <T extends class_2394> void registerParticleType(class_2396<T> type,
        Function<class_4002, class_707<T>> factory);

    <T extends class_5684 & class_5632> void registerIdentityTooltipMapping(Class<T> clazz);

    void registerItemProperty(class_1792 item, class_2960 id, class_1800 func);

    // On Forge, these are already exposed; on Farbc we do a mixin
    void setFilterSave(class_1044 texture, boolean filter, boolean mipmap);

    void restoreLastFilter(class_1044 texture);

    IClientXplatAbstractions INSTANCE = find();

    private static IClientXplatAbstractions find() {
        var providers = ServiceLoader.load(IClientXplatAbstractions.class).stream().toList();
        if (providers.size() != 1) {
            var names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException(
                "There should be exactly one IClientXplatAbstractions implementation on the classpath. Found: " + names);
        } else {
            var provider = providers.get(0);
            HexAPI.LOGGER.debug("Instantiating client xplat impl: " + provider.type().getName());
            return provider.get();
        }
    }
}
