package at.petrak.hexcasting.mixin.client;

import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_638;

@Mixin(class_638.class)
public abstract class MixinClientLevel {

	@Inject(method = "doAnimateTick",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/Block;animateTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V"),
			locals = LocalCapture.CAPTURE_FAILSOFT)
	public void addBuddingAmethystParticles(int baseX, int baseY, int baseZ, int range, Random rand, class_2248 marked, class_2338.class_2339 pos, CallbackInfo ci,
											int trueX, int trueY, int trueZ, class_2680 state) {
		class_638 self = ((class_638) (Object) this);

		if (state.method_27852(class_2246.field_27160)) {
			class_2394 options = new ConjureParticleOptions(0x8932b8, true);
			class_243 center = class_243.method_24953(pos);
			for (class_2350 direction : class_2350.values()) {
				int dX = direction.method_10148();
				int dY = direction.method_10164();
				int dZ = direction.method_10165();

				int count = rand.nextInt(10) / 5;
				for (int i = 0; i < count; i++) {
					double pX = center.field_1352 + (dX == 0 ? class_3532.method_15366(rand, -0.5D, 0.5D) : (double) dX * 0.55D);
					double pY = center.field_1351 + (dY == 0 ? class_3532.method_15366(rand, -0.5D, 0.5D) : (double) dY * 0.55D);
					double pZ = center.field_1350 + (dZ == 0 ? class_3532.method_15366(rand, -0.5D, 0.5D) : (double) dZ * 0.55D);
					self.method_8406(options, pX, pY, pZ, 0, 0, 0);
				}
			}
		}
	}

}
