package at.petrak.hexcasting.mixin;

import at.petrak.hexcasting.common.misc.Brainsweeping;
import net.minecraft.class_1640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import var;

// Prevents the witch from drinking potions
@Mixin(class_1640.class)
public class MixinWitch {
    @Redirect(method = "aiStep", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/monster/Witch;isAlive()Z"))
    private boolean isAliveForAiPurposes(class_1640 instance) {
        var self = (class_1640) (Object) this;
        return self.isAlive() && !Brainsweeping.isBrainswept(self);
    }
}
